/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.plugins.RemovePluginVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RemoveSettingsPlugin
extends Recipe {
    @Option(displayName="Plugin id", description="The plugin id to remove.", example="com.jfrog.bintray")
    private final String pluginId;

    public String getDisplayName() {
        return "Remove Gradle settings plugin";
    }

    public String getDescription() {
        return "Remove plugin from Gradle settings file `plugins` block by id.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new RemovePluginVisitor(this.pluginId));
    }

    public RemoveSettingsPlugin(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @NonNull
    public String toString() {
        return "RemoveSettingsPlugin(pluginId=" + this.getPluginId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveSettingsPlugin)) {
            return false;
        }
        RemoveSettingsPlugin other = (RemoveSettingsPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveSettingsPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        return result;
    }
}

