/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.gradle.internal.DefaultImportsCustomizer;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;

public class GradleParser
implements Parser<G.CompilationUnit> {
    private final GroovyParser buildParser;
    private final GroovyParser settingsParser;

    private GradleParser(Builder builder) {
        GroovyParser.Builder base = builder.groovyParser;
        this.buildParser = GroovyParser.builder((GroovyParser.Builder)base).classpath(builder.buildscriptClasspath).compilerCustomizers(new Consumer[]{new DefaultImportsCustomizer(), config -> config.setScriptBaseClass("RewriteGradleProject")}).build();
        this.settingsParser = GroovyParser.builder((GroovyParser.Builder)base).classpath(builder.settingsClasspath).compilerCustomizers(new Consumer[]{new DefaultImportsCustomizer(), config -> config.setScriptBaseClass("RewriteSettings")}).build();
    }

    public Stream<G.CompilationUnit> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        return StreamSupport.stream(sources.spliterator(), false).flatMap(source -> {
            if (source.getPath().endsWith("settings.gradle")) {
                return this.settingsParser.parseInputs(Collections.singletonList(source), relativeTo, ctx);
            }
            return this.buildParser.parseInputs(Collections.singletonList(source), relativeTo, ctx);
        });
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".gradle");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("build.gradle");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        protected GroovyParser.Builder groovyParser = GroovyParser.builder();
        @Nullable
        private Collection<Path> buildscriptClasspath = Builder.loadDefaultClasspath();
        @Nullable
        private Collection<Path> settingsClasspath = Builder.loadDefaultClasspath();

        public Builder() {
            super(G.CompilationUnit.class);
        }

        public Builder groovyParser(GroovyParser.Builder groovyParser) {
            this.groovyParser = groovyParser;
            return this;
        }

        public Builder buildscriptClasspath(Collection<Path> classpath) {
            this.buildscriptClasspath = classpath;
            return this;
        }

        public Builder buildscriptClasspath(String ... classpath) {
            this.buildscriptClasspath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder buildscriptClasspathFromResources(ExecutionContext ctx, String ... artifactNamesWithVersions) {
            this.buildscriptClasspath = JavaParser.dependenciesFromResources((ExecutionContext)ctx, (String[])artifactNamesWithVersions);
            return this;
        }

        public Builder settingsClasspath(Collection<Path> classpath) {
            this.settingsClasspath = classpath;
            return this;
        }

        public Builder settingsClasspath(String ... classpath) {
            this.settingsClasspath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder settingsClasspathFromResources(ExecutionContext ctx, String ... artifactNamesWithVersions) {
            this.settingsClasspath = JavaParser.dependenciesFromResources((ExecutionContext)ctx, (String[])artifactNamesWithVersions);
            return this;
        }

        public GradleParser build() {
            return new GradleParser(this);
        }

        public String getDslName() {
            return "gradle";
        }

        private static List<Path> loadDefaultClasspath() {
            try {
                Class.forName("org.gradle.api.Project");
                return JavaParser.runtimeClasspath();
            }
            catch (ClassNotFoundException e) {
                return JavaParser.dependenciesFromResources((ExecutionContext)new InMemoryExecutionContext(), (String[])new String[]{"gradle-base-services", "gradle-core-api", "gradle-language-groovy", "gradle-language-java", "gradle-logging", "gradle-messaging", "gradle-native", "gradle-process-services", "gradle-resources", "gradle-testing-base", "gradle-testing-jvm", "gradle-enterprise-gradle-plugin"});
            }
        }
    }
}

