/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.UpgradeDependencyVersion;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependency
extends Recipe {
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="corp.internal.openrewrite.recipe", required=false)
    @Nullable
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="rewrite-testing-frameworks", required=false)
    @Nullable
    private final String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Change Gradle dependency";
    }

    public String getDescription() {
        return "Change a Gradle dependency coordinates.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            final MethodMatcher dependencyDsl;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(ChangeDependency.this.oldGroupId + ":" + ChangeDependency.this.oldArtifactId)).getValue());
                this.dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)ctx);
                if (g != cu) {
                    GradleProject gp = (GradleProject)g.getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalArgumentException("Gradle files are expected to have a GradleProject marker."));
                    g = g.withMarkers(g.getMarkers().setByType((Marker)this.updateGradleModel(gp)));
                }
                return g;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!this.dependencyDsl.matches(m)) {
                    return m;
                }
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal || depArgs.get(0) instanceof G.GString || depArgs.get(0) instanceof G.MapEntry) {
                    m = this.updateDependency(m);
                } else if (depArgs.get(0) instanceof J.MethodInvocation && (((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("platform") || ((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("enforcedPlatform"))) {
                    m = m.withArguments(ListUtils.mapFirst((List)depArgs, platform -> this.updateDependency((J.MethodInvocation)platform)));
                }
                return m;
            }

            private J.MethodInvocation updateDependency(J.MethodInvocation m) {
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal) {
                    Dependency original;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && this.depMatcher.matches((original = DependencyStringNotationConverter.parse(gav)).getGroupId(), original.getArtifactId())) {
                        Dependency updated = original;
                        if (ChangeDependency.this.newGroupId != null && !updated.getGroupId().equals(ChangeDependency.this.newGroupId)) {
                            updated = updated.withGroupId(ChangeDependency.this.newGroupId);
                        }
                        if (ChangeDependency.this.newArtifactId != null && !updated.getArtifactId().equals(ChangeDependency.this.newArtifactId)) {
                            updated = updated.withArtifactId(ChangeDependency.this.newArtifactId);
                        }
                        if (ChangeDependency.this.newVersion != null) {
                            this.doAfterVisit(new UpgradeDependencyVersion(updated.getGroupId(), updated.getArtifactId(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern).getVisitor());
                        }
                        if (original != updated) {
                            String replacement = updated.toStringNotation();
                            m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, replacement)));
                        }
                    }
                } else if (m.getArguments().get(0) instanceof G.GString) {
                    Dependency original;
                    List strings = ((G.GString)depArgs.get(0)).getStrings();
                    if (strings.size() >= 2 && strings.get(0) instanceof J.Literal && this.depMatcher.matches((original = DependencyStringNotationConverter.parse((String)((J.Literal)strings.get(0)).getValue())).getGroupId(), original.getArtifactId())) {
                        Dependency updated = original;
                        if (ChangeDependency.this.newGroupId != null && !updated.getGroupId().equals(ChangeDependency.this.newGroupId)) {
                            updated = updated.withGroupId(ChangeDependency.this.newGroupId);
                        }
                        if (ChangeDependency.this.newArtifactId != null && !updated.getArtifactId().equals(ChangeDependency.this.newArtifactId)) {
                            updated = updated.withArtifactId(ChangeDependency.this.newArtifactId);
                        }
                        if (ChangeDependency.this.newVersion != null) {
                            this.doAfterVisit(new UpgradeDependencyVersion(updated.getGroupId(), updated.getArtifactId(), ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern).getVisitor());
                        }
                        if (original != updated) {
                            String replacement = updated.toStringNotation();
                            m = m.withArguments(ListUtils.mapFirst((List)depArgs, arg -> {
                                G.GString gString = (G.GString)arg;
                                return gString.withStrings(ListUtils.mapFirst((List)gString.getStrings(), l -> ((J.Literal)l).withValue((Object)replacement).withValueSource(replacement)));
                            }));
                        }
                    }
                } else if (m.getArguments().get(0) instanceof G.MapEntry) {
                    G.MapEntry groupEntry = null;
                    G.MapEntry artifactEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String valueDelimiter = "'";
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            if (value.getValueSource() != null) {
                                valueDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                            }
                            groupEntry = arg2;
                            groupId = valueValue;
                            continue;
                        }
                        if (!"name".equals(keyValue)) continue;
                        artifactEntry = arg2;
                        artifactId = valueValue;
                    }
                    if (groupId == null || artifactId == null) {
                        return m;
                    }
                    if (!this.depMatcher.matches(groupId, artifactId)) {
                        return m;
                    }
                    String updatedGroupId = groupId;
                    if (ChangeDependency.this.newGroupId != null && !updatedGroupId.equals(ChangeDependency.this.newGroupId)) {
                        updatedGroupId = ChangeDependency.this.newGroupId;
                    }
                    String updatedArtifactId = artifactId;
                    if (ChangeDependency.this.newArtifactId != null && !updatedArtifactId.equals(ChangeDependency.this.newArtifactId)) {
                        updatedArtifactId = ChangeDependency.this.newArtifactId;
                    }
                    if (ChangeDependency.this.newVersion != null) {
                        this.doAfterVisit(new UpgradeDependencyVersion(updatedGroupId, updatedArtifactId, ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern).getVisitor());
                    }
                    if (!updatedGroupId.equals(groupId) || !updatedArtifactId.equals(artifactId)) {
                        String delimiter = valueDelimiter;
                        G.MapEntry finalGroup = groupEntry;
                        G.MapEntry finalArtifact = artifactEntry;
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                            if (arg == finalGroup) {
                                return finalGroup.withValue((Expression)((J.Literal)finalGroup.getValue()).withValue((Object)ChangeDependency.this.newGroupId).withValueSource(delimiter + ChangeDependency.this.newGroupId + delimiter));
                            }
                            if (arg == finalArtifact) {
                                return finalArtifact.withValue((Expression)((J.Literal)finalArtifact.getValue()).withValue((Object)ChangeDependency.this.newArtifactId).withValueSource(delimiter + ChangeDependency.this.newArtifactId + delimiter));
                            }
                            return arg;
                        }));
                    }
                }
                return m;
            }

            private GradleProject updateGradleModel(GradleProject gp) {
                Map nameToConfiguration = gp.getNameToConfiguration();
                HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
                boolean anyChanged = false;
                Iterator iterator = nameToConfiguration.values().iterator();
                while (iterator.hasNext()) {
                    GradleDependencyConfiguration gdc;
                    GradleDependencyConfiguration newGdc = gdc = (GradleDependencyConfiguration)iterator.next();
                    newGdc = newGdc.withRequested(ListUtils.map((List)gdc.getRequested(), requested -> {
                        if (this.depMatcher.matches(requested.getGroupId(), requested.getArtifactId())) {
                            GroupArtifactVersion gav = requested.getGav();
                            if (ChangeDependency.this.newGroupId != null) {
                                gav = gav.withGroupId(ChangeDependency.this.newGroupId);
                            }
                            if (ChangeDependency.this.newArtifactId != null) {
                                gav = gav.withArtifactId(ChangeDependency.this.newArtifactId);
                            }
                            if (gav != requested.getGav()) {
                                return requested.withGav(gav);
                            }
                        }
                        return requested;
                    }));
                    anyChanged |= (newGdc = newGdc.withResolved(ListUtils.map((List)gdc.getResolved(), resolved -> {
                        if (this.depMatcher.matches(resolved.getGroupId(), resolved.getArtifactId())) {
                            ResolvedGroupArtifactVersion gav = resolved.getGav();
                            if (ChangeDependency.this.newGroupId != null) {
                                gav = gav.withGroupId(ChangeDependency.this.newGroupId);
                            }
                            if (ChangeDependency.this.newArtifactId != null) {
                                gav = gav.withArtifactId(ChangeDependency.this.newArtifactId);
                            }
                            if (gav != resolved.getGav()) {
                                return resolved.withGav(gav);
                            }
                        }
                        return resolved;
                    }))) != gdc;
                    newNameToConfiguration.put(newGdc.getName(), newGdc);
                }
                if (anyChanged) {
                    gp = gp.withNameToConfiguration(newNameToConfiguration);
                }
                return gp;
            }
        });
    }

    public ChangeDependency(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Nullable
    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Nullable
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "ChangeDependency(oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependency)) {
            return false;
        }
        ChangeDependency other = (ChangeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

