/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.UpdateGradleWrapper;
import org.openrewrite.gradle.toolingapi.GradleProject;
import org.openrewrite.gradle.toolingapi.OpenRewriteModel;
import org.openrewrite.gradle.toolingapi.OpenRewriteModelBuilder;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.UncheckedConsumer;

public class Assertions {
    private static final Parser.Builder gradleParser = GradleParser.builder().groovyParser(GroovyParser.builder().logCompilationWarningsAndErrors(true));

    private Assertions() {
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(@Nullable String version, @Nullable String distribution) {
        return sourceFiles -> {
            try {
                Path tempDirectory;
                Path projectDir = tempDirectory = Files.createTempDirectory("project", new FileAttribute[0]);
                try {
                    for (SourceFile sourceFile : sourceFiles) {
                        Properties.File f;
                        if (sourceFile instanceof G.CompilationUnit) {
                            G.CompilationUnit g = (G.CompilationUnit)sourceFile;
                            if (!g.getSourcePath().toString().endsWith(".gradle")) continue;
                            Path groovyGradle = tempDirectory.resolve(g.getSourcePath());
                            if (!tempDirectory.equals(groovyGradle.getParent()) && tempDirectory.equals(groovyGradle.getParent().getParent())) {
                                projectDir = groovyGradle.getParent();
                            }
                            Files.createDirectories(groovyGradle.getParent(), new FileAttribute[0]);
                            Files.write(groovyGradle, g.printAllAsBytes(), new OpenOption[0]);
                            continue;
                        }
                        if (!(sourceFile instanceof Properties.File) || !(f = (Properties.File)sourceFile).getSourcePath().endsWith("gradle.properties")) continue;
                        Path gradleProperties = tempDirectory.resolve(f.getSourcePath());
                        if (!tempDirectory.equals(gradleProperties.getParent()) && tempDirectory.equals(gradleProperties.getParent().getParent())) {
                            projectDir = gradleProperties.getParent();
                        }
                        Files.createDirectories(gradleProperties.getParent(), new FileAttribute[0]);
                        Files.write(gradleProperties, f.printAllAsBytes(), new OpenOption[0]);
                    }
                    if (version != null) {
                        GradleWrapper gradleWrapper = Objects.requireNonNull((GradleWrapper)GradleWrapper.validate((ExecutionContext)new InMemoryExecutionContext(), version, distribution, null, null).getValue());
                        Files.createDirectories(projectDir.resolve("gradle/wrapper/"), new FileAttribute[0]);
                        Files.write(projectDir.resolve(GradleWrapper.WRAPPER_PROPERTIES_LOCATION), ("distributionBase=GRADLE_USER_HOME\ndistributionPath=wrapper/dists\ndistributionUrl=" + gradleWrapper.getPropertiesFormattedUrl() + "\ndistributionSha256Sum=" + gradleWrapper.getDistributionChecksum().getHexValue() + "\nzipStoreBase=GRADLE_USER_HOME\nzipStorePath=wrapper/dists").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW);
                        Files.write(projectDir.resolve(GradleWrapper.WRAPPER_JAR_LOCATION), gradleWrapper.asRemote().printAllAsBytes(), StandardOpenOption.CREATE_NEW);
                        Path gradleSh = projectDir.resolve(GradleWrapper.WRAPPER_SCRIPT_LOCATION);
                        Files.copy(Objects.requireNonNull(UpdateGradleWrapper.class.getResourceAsStream("/gradlew")), gradleSh, new CopyOption[0]);
                        OperatingSystemProvenance current = OperatingSystemProvenance.current();
                        if (current.isLinux() || current.isMacOsX()) {
                            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(gradleSh, new LinkOption[0]);
                            permissions.add(PosixFilePermission.OWNER_EXECUTE);
                            Files.setPosixFilePermissions(gradleSh, permissions);
                        }
                        Files.copy(Objects.requireNonNull(UpdateGradleWrapper.class.getResourceAsStream("/gradlew.bat")), projectDir.resolve(GradleWrapper.WRAPPER_BATCH_LOCATION), new CopyOption[0]);
                    }
                    for (int i = 0; i < sourceFiles.size(); ++i) {
                        SourceFile sourceFile;
                        sourceFile = (SourceFile)sourceFiles.get(i);
                        if (!sourceFile.getSourcePath().toString().endsWith(".gradle") || sourceFile.getSourcePath().endsWith("settings.gradle")) continue;
                        OpenRewriteModel model = OpenRewriteModelBuilder.forProjectDirectory((File)projectDir.toFile(), (File)tempDirectory.resolve(sourceFile.getSourcePath()).toFile());
                        org.openrewrite.gradle.marker.GradleProject gradleProject = org.openrewrite.gradle.marker.GradleProject.fromToolingModel((GradleProject)model.gradleProject());
                        sourceFiles.set(i, (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)gradleProject)));
                    }
                }
                finally {
                    Assertions.deleteDirectory(tempDirectory.toFile());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(String version) {
        return Assertions.withToolingApi(version, "bin");
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi() {
        return Assertions.withToolingApi(null, null);
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before) {
        return Assertions.buildGradle(before, (SourceSpec<G.CompilationUnit> s) -> {});
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, null);
        gradle.path(Paths.get("build.gradle", new String[0]));
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after) {
        return Assertions.buildGradle(before, after, s -> {});
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, s -> after);
        gradle.path("build.gradle");
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before) {
        return Assertions.settingsGradle(before, (SourceSpec<G.CompilationUnit> s) -> {});
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, null);
        gradle.path(Paths.get("settings.gradle", new String[0]));
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after) {
        return Assertions.settingsGradle(before, after, s -> {});
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, s -> after);
        gradle.path("settings.gradle");
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                Assertions.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }
}

