/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.ipc.http.HttpSender;

public class GradlePluginUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> availablePluginVersions(String pluginId, ExecutionContext ctx) {
        String uri = "https://plugins.gradle.org/plugin/" + pluginId;
        HttpSender httpSender = HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender();
        try (HttpSender.Response response = httpSender.send(httpSender.get(uri).build());){
            if (!response.isSuccessful()) return Collections.emptyList();
            String responseBody = StringUtils.readFully((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
            ArrayList<String> versions = new ArrayList<String>();
            Matcher matcher = Pattern.compile("href=\"/plugin/" + pluginId + "/([^\"]+)\"").matcher(responseBody);
            int lastFind = 0;
            while (matcher.find(lastFind)) {
                versions.add(matcher.group(1));
                lastFind = matcher.end();
            }
            matcher = Pattern.compile("Version (\\S+) \\(latest\\)").matcher(responseBody);
            if (matcher.find()) {
                versions.add(matcher.group(1));
            }
            ArrayList<String> arrayList = versions;
            return arrayList;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptyList();
    }
}

