/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class ChangeJavaCompatibility
extends Recipe {
    @Option(displayName="New version", description="The Java version to update source compatibility to. All allowed variations of Gradle's `org.gradle.api.JavaVersion` are allowed. This means that we accept versions in the form of doubles (ex. 1.8, 1.11), whole numbers (ex. 8, 11), strings (ex. \"1.8\", \"8\", '1.11', '11'), and `org.gradle.api.JavaVersion` enum values (ex. `VERSION_1_8`, `VERSION_11`, `JavaVersion.VERSION_1_8`, `JavaVersion.VERSION_11`).", example="11")
    private final String newVersion;
    @Option(displayName="Compatibility Type", description="The compatibility type to change", valid={"source", "target"})
    private final String compatibilityType;

    public String getDisplayName() {
        return "Change Gradle project Java compatibility";
    }

    public String getDescription() {
        return "Find and updates the Java compatibility for the Gradle project.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            final MethodMatcher sourceCompatibilityDsl = new MethodMatcher("RewriteGradleProject setSourceCompatibility(..)");
            final MethodMatcher targetCompatibilityDsl = new MethodMatcher("RewriteGradleProject setTargetCompatibility(..)");

            public J visitAssignment(J.Assignment assignment, ExecutionContext executionContext) {
                int newMajor;
                J.Assignment a = (J.Assignment)super.visitAssignment(assignment, (Object)executionContext);
                if (a.getVariable() instanceof J.Identifier) {
                    J.Identifier var = (J.Identifier)a.getVariable();
                    if (!(ChangeJavaCompatibility.this.compatibilityType + "Compatibility").equals(var.getSimpleName())) {
                        return a;
                    }
                } else if (a.getVariable() instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)a.getVariable();
                    if (!(ChangeJavaCompatibility.this.compatibilityType + "Compatibility").equals(fieldAccess.getSimpleName())) {
                        return a;
                    }
                } else {
                    return a;
                }
                if ((newMajor = this.getMajorVersion(ChangeJavaCompatibility.this.newVersion)) == -1) {
                    return a;
                }
                Class<?> requestedType = this.determineRequestedType(ChangeJavaCompatibility.this.newVersion);
                int currentMajor = this.getMajorVersion(a.getAssignment());
                if (currentMajor != newMajor) {
                    a = a.withAssignment(this.changeExpression(a.getAssignment(), requestedType, ChangeJavaCompatibility.this.newVersion));
                }
                return a;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext);
                if ("source".equals(ChangeJavaCompatibility.this.compatibilityType) && !this.sourceCompatibilityDsl.matches(m) || "target".equals(ChangeJavaCompatibility.this.compatibilityType) && !this.targetCompatibilityDsl.matches(m)) {
                    return m;
                }
                int newMajor = this.getMajorVersion(ChangeJavaCompatibility.this.newVersion);
                if (newMajor == -1) {
                    return m;
                }
                Class<?> requestedType = this.determineRequestedType(ChangeJavaCompatibility.this.newVersion);
                int currentMajor = this.getMajorVersion((Expression)m.getArguments().get(0));
                if (currentMajor != newMajor) {
                    m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> this.changeExpression((Expression)arg, requestedType, ChangeJavaCompatibility.this.newVersion)));
                }
                return m;
            }

            private int getMajorVersion(String version) {
                try {
                    return Integer.parseInt(this.normalize(version));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }

            private int getMajorVersion(Expression expression) {
                if (expression instanceof J.Literal) {
                    J.Literal argument = (J.Literal)expression;
                    JavaType.Primitive type = argument.getType();
                    if (type == JavaType.Primitive.String) {
                        return this.getMajorVersion((String)argument.getValue());
                    }
                    if (type == JavaType.Primitive.Int) {
                        return (Integer)argument.getValue();
                    }
                    if (type == JavaType.Primitive.Double) {
                        return this.getMajorVersion(argument.getValue().toString());
                    }
                } else if (expression instanceof J.FieldAccess) {
                    J.FieldAccess field = (J.FieldAccess)expression;
                    J.Identifier identifier = field.getName();
                    return this.getMajorVersion(identifier.getSimpleName());
                }
                return -1;
            }

            private String normalize(String version) {
                if (version.contains("\"") || version.contains("'")) {
                    version = version.replace("\"", "").replace("'", "");
                }
                if (!version.contains(".") && !version.contains("_")) {
                    return version;
                }
                if (version.contains("_")) {
                    String removePrefix = version.substring(version.indexOf("_") + 1);
                    if (removePrefix.startsWith("1_")) {
                        return removePrefix.substring(removePrefix.indexOf("_") + 1);
                    }
                    return removePrefix;
                }
                return version.substring(version.indexOf(".") + 1);
            }

            private Class<?> determineRequestedType(String value) {
                if (value.contains("\"") || value.contains("'")) {
                    return String.class;
                }
                if (value.startsWith("JavaVersion.") || value.startsWith("VERSION_")) {
                    return Enum.class;
                }
                if (value.contains(".")) {
                    return Double.TYPE;
                }
                return Integer.TYPE;
            }

            private Expression changeExpression(Expression expression, Class<?> requestedType, String requestedValue) {
                if (expression instanceof J.Literal) {
                    J.Literal literal = (J.Literal)expression;
                    if (String.class.equals(requestedType)) {
                        expression = literal.withType((JavaType)JavaType.Primitive.String).withValue((Object)requestedValue).withValueSource(requestedValue);
                    } else if (Enum.class.equals(requestedType)) {
                        String name = requestedValue.substring(requestedValue.indexOf(".") + 1);
                        expression = new J.FieldAccess(Tree.randomId(), literal.getPrefix(), literal.getMarkers(), (Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "JavaVersion", (JavaType)JavaType.ShallowClass.build((String)"org.gradle.api.JavaVersion"), null), new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, null, null), Markers.EMPTY), (JavaType)JavaType.ShallowClass.build((String)"org.gradle.api.JavaVersion"));
                    } else if (Double.TYPE.equals(requestedType)) {
                        double doubleValue = Double.parseDouble(requestedValue);
                        expression = literal.withType((JavaType)JavaType.Primitive.Double).withValue((Object)doubleValue).withValueSource(requestedValue);
                    } else if (Integer.TYPE.equals(requestedType)) {
                        int intValue = Integer.parseInt(requestedValue);
                        expression = literal.withType((JavaType)JavaType.Primitive.Int).withValue((Object)intValue).withValueSource(requestedValue);
                    }
                } else if (expression instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)expression;
                    if (String.class.equals(requestedType)) {
                        expression = new J.Literal(Tree.randomId(), fieldAccess.getPrefix(), fieldAccess.getMarkers(), (Object)requestedValue, requestedValue, Collections.emptyList(), JavaType.Primitive.String);
                    } else if (Enum.class.equals(requestedType)) {
                        String name = requestedValue.substring(requestedValue.indexOf(".") + 1);
                        expression = fieldAccess.withName(fieldAccess.getName().withSimpleName(name));
                    } else if (Double.TYPE.equals(requestedType)) {
                        double doubleValue = Double.parseDouble(requestedValue);
                        expression = new J.Literal(Tree.randomId(), fieldAccess.getPrefix(), fieldAccess.getMarkers(), (Object)doubleValue, requestedValue, Collections.emptyList(), JavaType.Primitive.Double);
                    } else if (Integer.TYPE.equals(requestedType)) {
                        int intValue = Integer.parseInt(requestedValue);
                        expression = new J.Literal(Tree.randomId(), fieldAccess.getPrefix(), fieldAccess.getMarkers(), (Object)intValue, requestedValue, Collections.emptyList(), JavaType.Primitive.Int);
                    }
                }
                return expression;
            }
        };
    }

    public ChangeJavaCompatibility(String newVersion, String compatibilityType) {
        this.newVersion = newVersion;
        this.compatibilityType = compatibilityType;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public String getCompatibilityType() {
        return this.compatibilityType;
    }

    @NonNull
    public String toString() {
        return "ChangeJavaCompatibility(newVersion=" + this.getNewVersion() + ", compatibilityType=" + this.getCompatibilityType() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeJavaCompatibility)) {
            return false;
        }
        ChangeJavaCompatibility other = (ChangeJavaCompatibility)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$compatibilityType = this.getCompatibilityType();
        String other$compatibilityType = other.getCompatibilityType();
        return !(this$compatibilityType == null ? other$compatibilityType != null : !this$compatibilityType.equals(other$compatibilityType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeJavaCompatibility;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $compatibilityType = this.getCompatibilityType();
        result = result * 59 + ($compatibilityType == null ? 43 : $compatibilityType.hashCode());
        return result;
    }
}

