/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class ActivateStyle
extends Recipe {
    @Option(displayName="Fully qualified style name", description="The name of the style to activate.", example="org.openrewrite.java.IntelliJ")
    private final String fullyQualifiedStyleName;
    @Option(displayName="Overwrite existing styles", description="When set to `true` this Recipe will clear all existing active styles. When `false` the new style will be added after existing styles.", required=false)
    private final boolean overwriteExistingStyles;
    private static final String STYLE_PRESENT = "org.openrewrite.gradle.ActivateStyle.STYLE_PRESENT";
    private static final String STYLE_KEY = "systemProp.rewrite.activeStyles";

    public String getDisplayName() {
        return "Activate Style in Gradle Project";
    }

    public String getDescription() {
        return "Sets the specified style as active. Once the style has been set, future recipes will use the specified style for any changes they make. This recipe does not reformat anything on its own. Prefers to set the `activeStyle()` method in the `rewrite` DSL in a build.gradle.If no `rewrite` DSL can be found to update, will instead place a \"systemProp.rewrite.activeStyles\" entry within the project's gradle.properties. Styles can be provided by rewrite itself, defined in a rewrite.yml, or provided by recipe modules.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        AtomicBoolean applicable = new AtomicBoolean();
        AtomicBoolean gradlePropsExists = new AtomicBoolean();
        List after = ListUtils.map(before, sourceFile -> {
            String sourcePath = sourceFile.getSourcePath().toString();
            if (!applicable.get() && (sourcePath.endsWith(".gradle") || sourcePath.endsWith(".gradle.kts"))) {
                applicable.set(true);
            }
            if (sourceFile instanceof Properties.File && "gradle.properties".equals(sourcePath)) {
                gradlePropsExists.set(true);
            }
            if (!(sourceFile instanceof G.CompilationUnit) || !sourcePath.endsWith(".gradle")) {
                return sourceFile;
            }
            return (G.CompilationUnit)new ActivateStyleBuildGradle().visit((Tree)sourceFile, ctx);
        });
        if (applicable.get() && !((Boolean)ctx.pollMessage(STYLE_PRESENT, (Object)false)).booleanValue()) {
            after = gradlePropsExists.get() ? ListUtils.map((List)after, sourceFile -> {
                if (sourceFile instanceof Properties.File && "gradle.properties".equals(sourceFile.getSourcePath().toString())) {
                    return (SourceFile)new ActivateStyleGradleProperties().visit((Tree)sourceFile, ctx);
                }
                return sourceFile;
            }) : ListUtils.concat((List)after, (Object)((Properties.File)new PropertiesParser().parse(new String[]{"systemProp.rewrite.activeStyles=" + this.fullyQualifiedStyleName}).get(0)).withSourcePath(Paths.get("gradle.properties", new String[0])));
        }
        return after;
    }

    private boolean activeStyleAlreadySet(J tree) {
        AtomicBoolean b = new AtomicBoolean();
        new FindActiveStyleInvocation().visit((Tree)tree, b);
        return b.get();
    }

    public ActivateStyle(String fullyQualifiedStyleName, boolean overwriteExistingStyles) {
        this.fullyQualifiedStyleName = fullyQualifiedStyleName;
        this.overwriteExistingStyles = overwriteExistingStyles;
    }

    public String getFullyQualifiedStyleName() {
        return this.fullyQualifiedStyleName;
    }

    public boolean isOverwriteExistingStyles() {
        return this.overwriteExistingStyles;
    }

    @NonNull
    public String toString() {
        return "ActivateStyle(fullyQualifiedStyleName=" + this.getFullyQualifiedStyleName() + ", overwriteExistingStyles=" + this.isOverwriteExistingStyles() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivateStyle)) {
            return false;
        }
        ActivateStyle other = (ActivateStyle)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isOverwriteExistingStyles() != other.isOverwriteExistingStyles()) {
            return false;
        }
        String this$fullyQualifiedStyleName = this.getFullyQualifiedStyleName();
        String other$fullyQualifiedStyleName = other.getFullyQualifiedStyleName();
        return !(this$fullyQualifiedStyleName == null ? other$fullyQualifiedStyleName != null : !this$fullyQualifiedStyleName.equals(other$fullyQualifiedStyleName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ActivateStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isOverwriteExistingStyles() ? 79 : 97);
        String $fullyQualifiedStyleName = this.getFullyQualifiedStyleName();
        result = result * 59 + ($fullyQualifiedStyleName == null ? 43 : $fullyQualifiedStyleName.hashCode());
        return result;
    }

    private class FindActiveStyleInvocation
    extends GroovyVisitor<AtomicBoolean> {
        private FindActiveStyleInvocation() {
        }

        public J visitMethodInvocation(J.MethodInvocation m, AtomicBoolean found) {
            if ("activeStyle".equals(m.getSimpleName())) {
                for (Expression arg : m.getArguments()) {
                    if (!(arg instanceof J.Literal)) continue;
                    J.Literal a = (J.Literal)arg;
                    if (!ActivateStyle.this.fullyQualifiedStyleName.equals(a.getValue())) continue;
                    found.set(true);
                    break;
                }
                return m;
            }
            return super.visitMethodInvocation(m, (Object)found);
        }
    }

    private class ActivateStyleGradleProperties
    extends PropertiesVisitor<ExecutionContext> {
        private ActivateStyleGradleProperties() {
        }

        public Properties visitFile(Properties.File file, ExecutionContext executionContext) {
            Properties.File p = (Properties.File)super.visitFile(file, (Object)executionContext);
            AtomicBoolean keyExists = new AtomicBoolean();
            p = p.withContent(ListUtils.map((List)p.getContent(), content -> {
                if (!(content instanceof Properties.Entry)) {
                    return content;
                }
                Properties.Entry entry = (Properties.Entry)content;
                if (ActivateStyle.STYLE_KEY.equals(entry.getKey())) {
                    keyExists.set(true);
                    if (ActivateStyle.this.overwriteExistingStyles) {
                        if (!ActivateStyle.this.fullyQualifiedStyleName.equals(entry.getValue().getText())) {
                            entry = entry.withValue(entry.getValue().withText(ActivateStyle.this.fullyQualifiedStyleName));
                        }
                    } else {
                        List activeStyles = Arrays.stream(entry.getValue().getText().split(",")).collect(Collectors.toList());
                        if (activeStyles.contains(ActivateStyle.this.fullyQualifiedStyleName)) {
                            return entry;
                        }
                        activeStyles.add(ActivateStyle.this.fullyQualifiedStyleName);
                        entry = entry.withValue(entry.getValue().withText(String.join((CharSequence)",", activeStyles)));
                    }
                }
                return entry;
            }));
            if (!keyExists.get()) {
                p = p.withContent(ListUtils.concat((List)p.getContent(), (Object)new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, ActivateStyle.STYLE_KEY, "", Properties.Entry.Delimiter.EQUALS, new Properties.Value(Tree.randomId(), "", Markers.EMPTY, ActivateStyle.this.fullyQualifiedStyleName))));
            }
            return p;
        }
    }

    private class ActivateStyleBuildGradle
    extends GroovyVisitor<ExecutionContext> {
        private ActivateStyleBuildGradle() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            if ("rewrite".equals(m.getSimpleName()) && m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Lambda) {
                if (ActivateStyle.this.activeStyleAlreadySet((J)m)) {
                    ctx.putMessage(ActivateStyle.STYLE_PRESENT, (Object)true);
                    return m;
                }
                J.MethodInvocation maybeModified = (J.MethodInvocation)new ModifyActiveStyleInvocation().visitNonNull((Tree)m, ctx, this.getCursor().getParentOrThrow());
                if (maybeModified != m) {
                    ctx.putMessage(ActivateStyle.STYLE_PRESENT, (Object)true);
                    return maybeModified;
                }
                J.Lambda rewriteConfigBlock = (J.Lambda)m.getArguments().get(0);
                if (!(rewriteConfigBlock.getBody() instanceof J.Block)) {
                    return m;
                }
                J.Block body = (J.Block)rewriteConfigBlock.getBody();
                J.MethodInvocation activeStyleInvocation = new J.MethodInvocation(Tree.randomId(), Space.format((String)"\n"), Markers.EMPTY, null, null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "activeStyle", null, null), JContainer.build(Collections.singletonList(JRightPadded.build((Object)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)ActivateStyle.this.fullyQualifiedStyleName, "\"" + ActivateStyle.this.fullyQualifiedStyleName + "\"", null, JavaType.Primitive.String)))), null);
                activeStyleInvocation = (J.MethodInvocation)this.autoFormat((J)activeStyleInvocation, ctx, new Cursor(this.getCursor(), (Object)body));
                body = body.withStatements(ListUtils.concat((List)body.getStatements(), (Object)activeStyleInvocation));
                m = m.withArguments(Collections.singletonList(rewriteConfigBlock.withBody((J)body)));
                ctx.putMessage(ActivateStyle.STYLE_PRESENT, (Object)true);
            }
            return m;
        }
    }

    private class ModifyActiveStyleInvocation
    extends GroovyVisitor<ExecutionContext> {
        private ModifyActiveStyleInvocation() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext);
            if ("activeStyle".equals(m.getSimpleName())) {
                J.Literal newEntry = new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)ActivateStyle.this.fullyQualifiedStyleName, "\"" + ActivateStyle.this.fullyQualifiedStyleName + "\"", null, JavaType.Primitive.String);
                m = ActivateStyle.this.overwriteExistingStyles ? m.withArguments(Collections.singletonList(newEntry)) : m.withArguments(ListUtils.concat((List)m.getArguments(), (Object)newEntry));
                m = (J.MethodInvocation)this.autoFormat((J)m, executionContext);
            }
            return m;
        }
    }
}

