/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class UpgradeLiteralDependencyVersion
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Upgrade Gradle dependencies who use a fixed literal version";
    }

    public String getDescription() {
        return "A fixed literal version is a version that is not a variable or property or supplied indirectly by platform BOMs or similar means. For example, `com.google.guava:guava:29.0-jre`.";
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dependency = new MethodMatcher("DependencyHandlerSpec *(..)");
        final VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue());
        return new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                List depArgs;
                if (dependency.matches(method) && (depArgs = method.getArguments()).get(0) instanceof J.Literal) {
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    assert (gav != null);
                    String[] parts = gav.split(":");
                    if (gav.length() >= 2 && StringUtils.matchesGlob((String)parts[0], (String)UpgradeLiteralDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)parts[1], (String)UpgradeLiteralDependencyVersion.this.artifactId)) {
                        GradleProject gradleProject = (GradleProject)((G.CompilationUnit)this.getCursor().firstEnclosingOrThrow(G.CompilationUnit.class)).getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalArgumentException("Gradle files are expected to have a GradleProject marker."));
                        String version = parts[2];
                        if (version != null && !version.startsWith("$")) {
                            try {
                                String newVersion = this.findNewerVersion(UpgradeLiteralDependencyVersion.this.groupId, UpgradeLiteralDependencyVersion.this.artifactId, version, gradleProject, ctx);
                                if (newVersion == null || version.equals(newVersion)) {
                                    return method;
                                }
                                return method.withArguments(ListUtils.mapFirst((List)method.getArguments(), arg -> {
                                    J.Literal literal = (J.Literal)arg;
                                    String newGav = UpgradeLiteralDependencyVersion.this.groupId + ":" + UpgradeLiteralDependencyVersion.this.artifactId + ":" + newVersion;
                                    return literal.withValue((Object)newGav).withValueSource(Objects.requireNonNull(literal.getValueSource()).replace(gav, newGav));
                                }));
                            }
                            catch (MavenDownloadingException e) {
                                return (J)e.warn((Tree)method);
                            }
                        }
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            @Nullable
            private String findNewerVersion(String groupId, String artifactId, String version, GradleProject gradleProject, ExecutionContext ctx) throws MavenDownloadingException {
                if (versionComparator instanceof LatestPatch && !versionComparator.isValid(version, version)) {
                    return null;
                }
                try {
                    MavenMetadata mavenMetadata = UpgradeLiteralDependencyVersion.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, gradleProject, ctx));
                    ArrayList<String> versions = new ArrayList<String>();
                    for (String v : mavenMetadata.getVersioning().getVersions()) {
                        if (!versionComparator.isValid(version, v)) continue;
                        versions.add(v);
                    }
                    return versionComparator.upgrade(version, versions).orElse(null);
                }
                catch (IllegalStateException e) {
                    return null;
                }
            }

            public MavenMetadata downloadMetadata(String groupId, String artifactId, GradleProject gradleProject, ExecutionContext ctx) throws MavenDownloadingException {
                return new MavenPomDownloader(Collections.emptyMap(), ctx, null, null).downloadMetadata(new GroupArtifact(groupId, artifactId), null, gradleProject.getMavenRepositories());
            }
        };
    }

    public UpgradeLiteralDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradeLiteralDependencyVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeLiteralDependencyVersion)) {
            return false;
        }
        UpgradeLiteralDependencyVersion other = (UpgradeLiteralDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeLiteralDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

