/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Parser;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.toolingapi.GradleProject;
import org.openrewrite.gradle.toolingapi.OpenRewriteModel;
import org.openrewrite.gradle.toolingapi.OpenRewriteModelBuilder;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.internal.ThrowingUnaryOperator;

public class Assertions {
    private static final Parser.Builder gradleParser = GradleParser.builder().groovyParser(GroovyParser.builder().logCompilationWarningsAndErrors(true));

    private Assertions() {
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before) {
        return Assertions.buildGradle(before, (SourceSpec<G.CompilationUnit> s) -> {});
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, null);
        gradle.path(Paths.get("build.gradle", new String[0]));
        Assertions.acceptSpec(spec, (SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after) {
        return Assertions.buildGradle(before, after, s -> {});
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, s -> after);
        gradle.path("build.gradle");
        Assertions.acceptSpec(spec, (SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before) {
        return Assertions.settingsGradle(before, (SourceSpec<G.CompilationUnit> s) -> {});
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, null);
        gradle.path(Paths.get("settings.gradle", new String[0]));
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after) {
        return Assertions.settingsGradle(before, after, s -> {});
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, s -> after);
        gradle.path("settings.gradle");
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    private static void acceptSpec(Consumer<SourceSpec<G.CompilationUnit>> spec, SourceSpec<G.CompilationUnit> buildGradle) {
        ThrowingUnaryOperator userSuppliedBeforeRecipe = buildGradle.getBeforeRecipe();
        buildGradle.mapBeforeRecipe(cu -> {
            G.CompilationUnit compilationUnit;
            G.CompilationUnit c = (G.CompilationUnit)userSuppliedBeforeRecipe.apply(cu);
            Path projectDir = Files.createTempDirectory("project", new FileAttribute[0]);
            Path buildGradleOnDisk = projectDir.resolve("build.gradle");
            try {
                Files.write(buildGradleOnDisk, c.printAllAsBytes(), new OpenOption[0]);
                OpenRewriteModel model = OpenRewriteModelBuilder.forProjectDirectory((File)projectDir.toFile());
                compilationUnit = c.withMarkers(c.getMarkers().add((Marker)org.openrewrite.gradle.marker.GradleProject.fromToolingModel((GradleProject)model.gradleProject())));
            }
            catch (Throwable throwable) {
                try {
                    Assertions.deleteDirectory(projectDir.toFile());
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Assertions.deleteDirectory(projectDir.toFile());
            return compilationUnit;
        });
        spec.accept(buildGradle);
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                Assertions.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }
}

