/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.internal.PatternSpecFactory;
import org.gradle.cache.internal.HeapProportionalCacheSizer;
import org.gradle.internal.UncheckedException;

public class CachingPatternSpecFactory
extends PatternSpecFactory {
    private static final int RESULTS_CACHE_MAX_SIZE = 100000;
    private static final int INSTANCES_MAX_SIZE = 30000;
    private final HeapProportionalCacheSizer cacheSizer = new HeapProportionalCacheSizer();
    private final Cache<SpecKey, Spec<FileTreeElement>> specInstanceCache = CacheBuilder.newBuilder().maximumSize((long)this.cacheSizer.scaleCacheSize(30000)).build();

    @Override
    protected Spec<FileTreeElement> createSpec(final Collection<String> patterns, final boolean include, final boolean caseSensitive) {
        SpecKey key = new SpecKey(ImmutableList.copyOf(patterns), include, caseSensitive);
        try {
            return (Spec)this.specInstanceCache.get((Object)key, (Callable)new Callable<Spec<FileTreeElement>>(){

                @Override
                public Spec<FileTreeElement> call() throws Exception {
                    Spec spec = CachingPatternSpecFactory.super.createSpec(patterns, include, caseSensitive);
                    return new CachingSpec(spec);
                }
            });
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
    }

    private static class SpecKey {
        private final ImmutableList<String> patterns;
        private final boolean include;
        private final boolean caseSensitive;
        private final int hashCode;

        private SpecKey(ImmutableList<String> patterns, boolean include, boolean caseSensitive) {
            this.patterns = patterns;
            this.include = include;
            this.caseSensitive = caseSensitive;
            this.hashCode = Objects.hashCode((Object[])new Object[]{patterns, include, caseSensitive});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecKey that = (SpecKey)o;
            return Objects.equal(this.patterns, that.patterns) && Objects.equal((Object)this.include, (Object)that.include) && Objects.equal((Object)this.caseSensitive, (Object)that.caseSensitive);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("patterns", this.patterns).add("include", this.include).add("caseSensitive", this.caseSensitive).toString();
        }
    }

    private class CachingSpec
    implements Spec<FileTreeElement> {
        private final Spec<FileTreeElement> spec;
        private final Cache<RelativePath, Boolean> resultCache;

        CachingSpec(Spec<FileTreeElement> spec) {
            this.resultCache = CacheBuilder.newBuilder().maximumSize((long)CachingPatternSpecFactory.this.cacheSizer.scaleCacheSize(100000)).build();
            this.spec = spec;
        }

        @Override
        public boolean isSatisfiedBy(final FileTreeElement element) {
            try {
                return (Boolean)this.resultCache.get((Object)element.getRelativePath(), (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return CachingSpec.this.spec.isSatisfiedBy(element);
                    }
                });
            }
            catch (ExecutionException e) {
                throw UncheckedException.throwAsUncheckedException(e.getCause());
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("spec", this.spec).toString();
        }
    }
}

