/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.RemoteArchive;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class GradleWrapper {
    public static final Path WRAPPER_JAR_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.jar", new String[0]);
    public static final Path WRAPPER_PROPERTIES_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.properties", new String[0]);
    public static final Path WRAPPER_SCRIPT_LOCATION = Paths.get("gradlew", new String[0]);
    public static final Path WRAPPER_BATCH_LOCATION = Paths.get("gradlew.bat", new String[0]);
    private final String version;
    private final DistributionType distributionType;
    static final FileAttributes WRAPPER_JAR_FILE_ATTRIBUTES = new FileAttributes(null, null, null, true, true, false, 0L);

    public static Validated validate(final String version, final @Nullable String distributionTypeName, final HttpSender httpSender) {
        return new Validated.Both(Validated.test((String)"distributionType", (String)"must be a valid distribution type", (Object)distributionTypeName, dt -> {
            if (distributionTypeName == null) {
                return true;
            }
            try {
                DistributionType.valueOf(dt);
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }), Semver.validate((String)version, null)){
            GradleWrapper wrapper;

            public boolean isValid() {
                if (!super.isValid()) {
                    return false;
                }
                try {
                    this.buildWrapper();
                    return true;
                }
                catch (Throwable t) {
                    return false;
                }
            }

            public GradleWrapper getValue() {
                return this.buildWrapper();
            }

            private GradleWrapper buildWrapper() {
                GradleWrapper gradleWrapper;
                block9: {
                    DistributionType distributionType = distributionTypeName == null ? DistributionType.Bin : Arrays.stream(DistributionType.values()).filter(dt -> dt.name().equalsIgnoreCase(distributionTypeName)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown distribution type " + distributionTypeName));
                    VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)version, null).getValue());
                    InputStream is = httpSender.send(httpSender.get("https://services.gradle.org/distributions").build()).getBody();
                    try {
                        Scanner scanner = new Scanner(is);
                        Pattern wrapperPattern = Pattern.compile("gradle-(.+)-" + distributionType.toString().toLowerCase() + "\\.zip(?!\\.sha)");
                        ArrayList<String> allVersions = new ArrayList<String>();
                        while (scanner.findWithinHorizon(wrapperPattern, 0) != null) {
                            allVersions.add(scanner.match().group(1));
                        }
                        scanner.close();
                        String version2 = allVersions.stream().filter(v -> versionComparator.isValid(null, v)).max((v1, v2) -> versionComparator.compare(null, v1, v2)).orElseThrow(() -> new IllegalStateException("Expected to find at least one Gradle wrapper version to select from."));
                        gradleWrapper = new GradleWrapper(version2, distributionType);
                        if (is == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    is.close();
                }
                return gradleWrapper;
            }
        };
    }

    public String getDistributionUrl() {
        return "https://services.gradle.org/distributions/gradle-" + this.version + "-" + this.distributionType.toString().toLowerCase() + ".zip";
    }

    public String getPropertiesFormattedUrl() {
        return this.getDistributionUrl().replaceAll("(?<!\\\\)://", "\\\\://");
    }

    public RemoteArchive asRemote() {
        return new RemoteArchive(Tree.randomId(), WRAPPER_JAR_LOCATION, Markers.EMPTY, URI.create(this.getDistributionUrl()), null, false, WRAPPER_JAR_FILE_ATTRIBUTES, "gradle-wrapper.jar is part of the gradle wrapper", Paths.get("gradle-" + this.version + "/lib/gradle-wrapper-" + this.version + ".jar!gradle-wrapper.jar", new String[0]));
    }

    public GradleWrapper(String version, DistributionType distributionType) {
        this.version = version;
        this.distributionType = distributionType;
    }

    public String getVersion() {
        return this.version;
    }

    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleWrapper)) {
            return false;
        }
        GradleWrapper other = (GradleWrapper)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        DistributionType this$distributionType = this.getDistributionType();
        DistributionType other$distributionType = other.getDistributionType();
        return !(this$distributionType == null ? other$distributionType != null : !((Object)((Object)this$distributionType)).equals((Object)other$distributionType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        DistributionType $distributionType = this.getDistributionType();
        result = result * 59 + ($distributionType == null ? 43 : ((Object)((Object)$distributionType)).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "GradleWrapper(version=" + this.getVersion() + ", distributionType=" + (Object)((Object)this.getDistributionType()) + ")";
    }

    public static enum DistributionType {
        Bin,
        All;

    }
}

