/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class AddDelegatesToGradleApi
extends Recipe {
    private static final JavaType.ShallowClass CLOSURE_TYPE = JavaType.ShallowClass.build((String)"groovy.lang.Closure");
    private static final JavaType.ShallowClass ACTION_TYPE = JavaType.ShallowClass.build((String)"org.gradle.api.Action");
    private static final JavaType.ShallowClass DELEGATES_TO_TYPE = JavaType.ShallowClass.build((String)"groovy.lang.DelegatesTo");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("(?<!also)[\\s*]++passed[\\s*]+to[\\s*]+the[\\s*]+closure[^.]+parameter", 32);

    public String getDisplayName() {
        return "Add `@DelegatesTo` to the Gradle API";
    }

    public String getDescription() {
        return "The Gradle API has methods which accept `groovy.lang.Closure`. Typically, there is an overload which accepts an `org.gradle.api.Action`.This recipe takes the type declared as the receiver of the `Action` overload and adds an appropriate `@groovy.lang.DelegatesTo` annotation to the `Closure` overload.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("groovy.lang.Closure");
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext context) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)context);
                if (!AddDelegatesToGradleApi.hasClosureParameter(md) || AddDelegatesToGradleApi.commentSuggestsNoDelegate(md)) {
                    return md;
                }
                md = md.withParameters(ListUtils.map((List)md.getParameters(), it -> {
                    if (!(it instanceof J.VariableDeclarations)) {
                        return it;
                    }
                    J.VariableDeclarations param = (J.VariableDeclarations)it;
                    if (!TypeUtils.isOfType((JavaType)param.getType(), (JavaType)param.getType()) || !FindAnnotations.find((J)param, (String)"@groovy.lang.DelegatesTo").isEmpty()) {
                        return param;
                    }
                    if (method.getMethodType() == null || !(method.getMethodType().getDeclaringType() instanceof JavaType.Class)) {
                        return param;
                    }
                    MethodMatcher matcher = new MethodMatcher(method.getMethodType().withParameterTypes(ListUtils.map((List)method.getMethodType().getParameterTypes(), p -> {
                        if (TypeUtils.isOfClassType((JavaType)p, (String)CLOSURE_TYPE.getFullyQualifiedName())) {
                            return ACTION_TYPE;
                        }
                        return p;
                    })));
                    JavaType.Class declaringClass = (JavaType.Class)method.getMethodType().getDeclaringType();
                    Optional<JavaType> maybeDelegateType = declaringClass.getMethods().stream().filter(arg_0 -> ((MethodMatcher)matcher).matches(arg_0)).map(m -> (JavaType.Parameterized)m.getParameterTypes().stream().filter(mp -> TypeUtils.isOfClassType((JavaType)mp, (String)ACTION_TYPE.getFullyQualifiedName())).findFirst().get()).filter(m -> m.getTypeParameters().size() == 1).map(m -> (JavaType)m.getTypeParameters().get(0)).findAny();
                    if (!maybeDelegateType.isPresent()) {
                        return param;
                    }
                    JavaType.FullyQualified delegateType = AddDelegatesToGradleApi.unwrapGenericTypeVariable(maybeDelegateType.get());
                    if (delegateType == null) {
                        return param;
                    }
                    String simpleName = delegateType.getFullyQualifiedName().substring(delegateType.getFullyQualifiedName().lastIndexOf(46) + 1);
                    param = (J.VariableDeclarations)param.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"@DelegatesTo(#{}.class)").imports(new String[]{delegateType.getFullyQualifiedName(), DELEGATES_TO_TYPE.getFullyQualifiedName()}).javaParser(() -> JavaParser.fromJavaVersion().classpath(new String[]{"groovy"}).build()).build(), param.getCoordinates().addAnnotation(Comparator.comparing(a -> 0)), new Object[]{simpleName});
                    this.maybeAddImport((JavaType.FullyQualified)DELEGATES_TO_TYPE);
                    return param;
                }));
                return md;
            }
        };
    }

    @Nullable
    private static JavaType.FullyQualified unwrapGenericTypeVariable(JavaType type) {
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable genericType = (JavaType.GenericTypeVariable)type;
            if (genericType.getBounds().size() == 1) {
                return AddDelegatesToGradleApi.unwrapGenericTypeVariable((JavaType)genericType.getBounds().get(0));
            }
            return null;
        }
        return TypeUtils.asFullyQualified((JavaType)type);
    }

    private static boolean commentSuggestsNoDelegate(J.MethodDeclaration methodDeclaration) {
        return methodDeclaration.getComments().stream().anyMatch(comment -> COMMENT_PATTERN.matcher(comment.printComment()).find());
    }

    private static boolean hasClosureParameter(J.MethodDeclaration methodDeclaration) {
        return methodDeclaration.getParameters().stream().anyMatch(param -> param instanceof J.VariableDeclarations && TypeUtils.isOfClassType((JavaType)((J.VariableDeclarations)param).getType(), (String)CLOSURE_TYPE.getFullyQualifiedName()));
    }
}

