/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.binary.BinaryParser;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.text.PlainText;

public final class UpdateGradleWrapper
extends Recipe {
    private static final String DEFAULT_VERSION = "7.4.2";
    private static final Path WRAPPER_PROPERTIES_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.properties", new String[0]);
    private static final Path WRAPPER_SCRIPT_LOCATION = Paths.get("gradlew", new String[0]);
    private static final Path WRAPPER_BATCH_LOCATION = Paths.get("gradlew.bat", new String[0]);
    private static final Path WRAPPER_JAR_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.jar", new String[0]);
    @Option(displayName="Version", description="The version of Gradle to use. Defaults to 7.4.2", example="7.4.2", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Distribution type", description="The distribution of Gradle to use. \"bin\" includes Gradle binaries. \"all\" includes Gradle binaries, source code, and documentation. If not specified the existing distribution type will be used.", example="bin", required=false)
    @Nullable
    private final String distribution;
    @Option(displayName="Distribution Url", description="The URL to download the Gradle distribution from. Providing the distribution url overrides the \"Version\" and \"Distribution type\" parameters. This is intended to cover customized distributions of the Gradle wrapper.", example="https://services.gradle.org/distributions/gradle-7.4.2-bin.zip", required=false)
    @Nullable
    private final String distributionUrl;

    public String getDisplayName() {
        return "Update Gradle wrapper";
    }

    public String getDescription() {
        return "Update the version of Gradle used in an existing Gradle Wrapper.";
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new PropertiesVisitor<ExecutionContext>(){

            public Properties visitFile(Properties.File file, ExecutionContext context) {
                if (!PathUtils.equalIgnoringSeparators((Path)file.getSourcePath(), (Path)WRAPPER_PROPERTIES_LOCATION)) {
                    return file;
                }
                return super.visitFile(file, (Object)context);
            }

            public Properties visitEntry(Properties.Entry entry, ExecutionContext context) {
                String currentVersion;
                if (!"distributionUrl".equals(entry.getKey())) {
                    return entry;
                }
                String currentDistributionUrl = entry.getValue().getText();
                if (!(UpdateGradleWrapper.this.distributionUrl == null || UpdateGradleWrapper.this.distributionUrl.equals(currentDistributionUrl) && UpdateGradleWrapper.this.distributionUrl.equals(currentDistributionUrl.replace("https\\://", "https://")))) {
                    return entry.withMarkers(entry.getMarkers().searchResult());
                }
                String[] distributionComponents = currentDistributionUrl.substring(currentDistributionUrl.lastIndexOf(47) + 1).split("-");
                if (distributionComponents.length != 3) {
                    return entry;
                }
                String desiredVersion = UpdateGradleWrapper.this.version == null ? UpdateGradleWrapper.DEFAULT_VERSION : UpdateGradleWrapper.this.version;
                if (!desiredVersion.equals(currentVersion = distributionComponents[1])) {
                    return entry.withMarkers(entry.getMarkers().searchResult());
                }
                if (UpdateGradleWrapper.this.distribution == null) {
                    return entry;
                }
                String currentDistribution = distributionComponents[2].substring(0, distributionComponents[2].indexOf(46));
                if (!UpdateGradleWrapper.this.distribution.equals(currentDistribution)) {
                    return entry.withMarkers(entry.getMarkers().searchResult());
                }
                return entry;
            }
        };
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        Binary gradleWrapperJar = (Binary)new BinaryParser().parseInputs(Collections.singletonList(new Parser.Input(Paths.get("gradle/wrapper/gradle-wrapper.jar", new String[0]), () -> UpdateGradleWrapper.class.getResourceAsStream("/gradle-wrapper.jar.dontunpack"))), null, ctx).get(0);
        return ListUtils.concat((List)ListUtils.map(before, sourceFile -> {
            if (sourceFile instanceof PlainText && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)WRAPPER_SCRIPT_LOCATION)) {
                PlainText gradlew = (PlainText)sourceFile;
                String gradlewText = StringUtils.readFully((InputStream)UpdateGradleWrapper.class.getResourceAsStream("/gradlew"));
                if (!gradlewText.equals(gradlew.getText())) {
                    gradlew = gradlew.withText(gradlewText);
                }
                return gradlew;
            }
            if (sourceFile instanceof PlainText && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)WRAPPER_BATCH_LOCATION)) {
                PlainText gradlewBat = (PlainText)sourceFile;
                String gradlewBatText = StringUtils.readFully((InputStream)UpdateGradleWrapper.class.getResourceAsStream("/gradlew.bat"));
                if (!gradlewBatText.equals(gradlewBat.getText())) {
                    gradlewBat = gradlewBat.withText(gradlewBatText);
                }
                return gradlewBat;
            }
            if (sourceFile instanceof Properties.File) {
                return (Properties.File)new UpdateWrapperPropsVisitor().visitNonNull((Tree)sourceFile, ctx);
            }
            return sourceFile;
        }), (Object)gradleWrapperJar);
    }

    public UpdateGradleWrapper(@Nullable String version, @Nullable String distribution, @Nullable String distributionUrl) {
        this.version = version;
        this.distribution = distribution;
        this.distributionUrl = distributionUrl;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getDistribution() {
        return this.distribution;
    }

    @Nullable
    public String getDistributionUrl() {
        return this.distributionUrl;
    }

    @NonNull
    public String toString() {
        return "UpdateGradleWrapper(version=" + this.getVersion() + ", distribution=" + this.getDistribution() + ", distributionUrl=" + this.getDistributionUrl() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGradleWrapper)) {
            return false;
        }
        UpdateGradleWrapper other = (UpdateGradleWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        String this$distributionUrl = this.getDistributionUrl();
        String other$distributionUrl = other.getDistributionUrl();
        return !(this$distributionUrl == null ? other$distributionUrl != null : !this$distributionUrl.equals(other$distributionUrl));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateGradleWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        String $distributionUrl = this.getDistributionUrl();
        result = result * 59 + ($distributionUrl == null ? 43 : $distributionUrl.hashCode());
        return result;
    }

    private class UpdateWrapperPropsVisitor
    extends PropertiesVisitor<ExecutionContext> {
        private UpdateWrapperPropsVisitor() {
        }

        public Properties visitFile(Properties.File file, ExecutionContext context) {
            if (!PathUtils.equalIgnoringSeparators((Path)file.getSourcePath(), (Path)WRAPPER_PROPERTIES_LOCATION)) {
                return file;
            }
            return super.visitFile(file, (Object)context);
        }

        public Properties visitEntry(Properties.Entry entry, ExecutionContext context) {
            if (!"distributionUrl".equals(entry.getKey())) {
                return entry;
            }
            String desiredDistributionUrl = this.getDesiredDistributionUrl(entry.getValue().getText());
            return entry.withValue(entry.getValue().withText(desiredDistributionUrl));
        }

        private String getDesiredDistributionUrl(String currentDistributionUrl) {
            if (UpdateGradleWrapper.this.distributionUrl != null) {
                return UpdateGradleWrapper.this.distributionUrl.replaceAll("(?<!\\\\)://", "\\\\://");
            }
            String desiredVersion = UpdateGradleWrapper.this.version == null ? UpdateGradleWrapper.DEFAULT_VERSION : UpdateGradleWrapper.this.version;
            String desiredDistributionUrl = UpdateGradleWrapper.this.distribution == null ? currentDistributionUrl.substring(0, currentDistributionUrl.lastIndexOf(47) + 1) + "gradle-" + desiredVersion + currentDistributionUrl.substring(currentDistributionUrl.lastIndexOf(45)) : currentDistributionUrl.substring(0, currentDistributionUrl.lastIndexOf(47) + 1) + "gradle-" + desiredVersion + "-" + UpdateGradleWrapper.this.distribution + ".zip";
            return desiredDistributionUrl;
        }
    }
}

