/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

class CategoryFilter
extends Filter {
    private final ClassLoader applicationClassLoader;
    private final Set<String> inclusions;
    private final Set<String> exclusions;

    CategoryFilter(Set<String> inclusions, Set<String> exclusions, ClassLoader applicationClassLoader) {
        this.inclusions = inclusions;
        this.exclusions = exclusions;
        this.applicationClassLoader = applicationClassLoader;
    }

    public boolean shouldRun(Description description) {
        Class testClass = description.getTestClass();
        this.verifyCategories(testClass);
        Description parent = description.isSuite() || testClass == null ? null : Description.createSuiteDescription((Class)testClass);
        return this.shouldRun(description, parent);
    }

    private void verifyCategories(Class<?> testClass) {
        if (testClass == null) {
            return;
        }
        for (String cls : this.inclusions) {
            this.loadClass(testClass.getClassLoader(), cls);
        }
        for (String cls : this.exclusions) {
            this.loadClass(testClass.getClassLoader(), cls);
        }
    }

    private boolean shouldRun(Description description, Description parent) {
        if (this.hasCorrectCategoryAnnotation(description, parent)) {
            return true;
        }
        for (Description each : description.getChildren()) {
            if (!this.shouldRun(each, description)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCorrectCategoryAnnotation(Description description, Description parent) {
        HashSet<Class> categories = new HashSet<Class>();
        Category annotation = (Category)description.getAnnotation(Category.class);
        if (annotation != null) {
            categories.addAll(Arrays.asList(annotation.value()));
        }
        if (parent != null && (annotation = (Category)parent.getAnnotation(Category.class)) != null) {
            categories.addAll(Arrays.asList(annotation.value()));
        }
        boolean result = this.inclusions.isEmpty();
        for (Class category : categories) {
            if (!this.matches(category, this.inclusions)) continue;
            result = true;
            break;
        }
        if (result) {
            for (Class category : categories) {
                if (!this.matches(category, this.exclusions)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean matches(Class<?> category, Set<String> categories) {
        ClassLoader classLoader = category.getClassLoader();
        for (String cls : categories) {
            if (!this.loadClass(classLoader, cls).isAssignableFrom(category)) continue;
            return true;
        }
        return false;
    }

    private Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                classLoader = this.applicationClassLoader;
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidUserDataException(String.format("Can't load category class [%s].", className), e);
        }
    }

    public final String describe() {
        StringBuilder sb = new StringBuilder();
        if (!this.inclusions.isEmpty()) {
            sb.append("(");
            sb.append(StringUtils.join(this.inclusions, (String)" OR "));
            sb.append(")");
            if (!this.exclusions.isEmpty()) {
                sb.append(" AND ");
            }
        }
        if (!this.exclusions.isEmpty()) {
            sb.append("NOT (");
            sb.append(StringUtils.join(this.exclusions, (String)" OR "));
            sb.append(")");
        }
        return sb.toString();
    }
}

