/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.IntSetSerializer;
import org.gradle.internal.serialize.InterningStringSerializer;
import org.gradle.internal.serialize.SetSerializer;

public class ClassAnalysisSerializer
extends AbstractSerializer<ClassAnalysis> {
    private final StringInterner interner;
    private final SetSerializer<String> stringSetSerializer;

    public ClassAnalysisSerializer(StringInterner interner) {
        this.stringSetSerializer = new SetSerializer<String>(new InterningStringSerializer(interner), false);
        this.interner = interner;
    }

    @Override
    public ClassAnalysis read(Decoder decoder) throws Exception {
        String className = this.interner.intern(decoder.readString());
        boolean relatedToAll = decoder.readBoolean();
        Set privateClasses = (Set)this.stringSetSerializer.read(decoder);
        Set accessibleClasses = (Set)this.stringSetSerializer.read(decoder);
        IntSet constants = IntSetSerializer.INSTANCE.read(decoder);
        return new ClassAnalysis(className, privateClasses, accessibleClasses, relatedToAll, constants);
    }

    @Override
    public void write(Encoder encoder, ClassAnalysis value) throws Exception {
        encoder.writeString(value.getClassName());
        encoder.writeBoolean(value.isDependencyToAll());
        this.stringSetSerializer.write(encoder, value.getPrivateClassDependencies());
        this.stringSetSerializer.write(encoder, value.getAccessibleClassDependencies());
        IntSetSerializer.INSTANCE.write(encoder, value.getConstants());
    }
}

