/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import javax.tools.JavaCompiler;
import org.gradle.api.JavaVersion;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.reflect.DirectInstantiator;

public class JdkTools {
    private static final String DEFAULT_COMPILER_IMPL_NAME = "com.sun.tools.javac.api.JavacTool";
    private static final AtomicReference<JdkTools> INSTANCE = new AtomicReference();
    private final ClassLoader isolatedToolsLoader;
    private final boolean isJava9Compatible;

    public static JdkTools current() {
        JdkTools jdkTools = INSTANCE.get();
        if (jdkTools == null) {
            INSTANCE.compareAndSet(null, new JdkTools(Jvm.current()));
            jdkTools = INSTANCE.get();
        }
        return jdkTools;
    }

    JdkTools(JavaInfo javaInfo) {
        DefaultClassLoaderFactory defaultClassLoaderFactory = new DefaultClassLoaderFactory();
        JavaVersion javaVersion = Jvm.current().getJavaVersion();
        boolean java9Compatible = javaVersion.isJava9Compatible();
        ClassLoader filteringClassLoader = this.getSystemFilteringClassLoader(defaultClassLoaderFactory, java9Compatible);
        if (!java9Compatible) {
            File toolsJar = javaInfo.getToolsJar();
            if (toolsJar == null) {
                throw new IllegalStateException("Could not find tools.jar. Please check that " + javaInfo.getJavaHome().getAbsolutePath() + " contains a valid JDK installation.");
            }
            ClassPath defaultClassPath = DefaultClassPath.of(toolsJar);
            this.isolatedToolsLoader = new VisitableURLClassLoader("jdk-tools", filteringClassLoader, defaultClassPath.getAsURLs());
            this.isJava9Compatible = false;
        } else {
            this.isolatedToolsLoader = filteringClassLoader;
            this.isJava9Compatible = true;
        }
    }

    private ClassLoader getSystemFilteringClassLoader(ClassLoaderFactory classLoaderFactory, boolean java9compatible) {
        FilteringClassLoader.Spec filterSpec = new FilteringClassLoader.Spec();
        if (java9compatible) {
            filterSpec.allowPackage("com.sun.tools");
        }
        return classLoaderFactory.createFilteringClassLoader(ClassLoader.getSystemClassLoader(), filterSpec);
    }

    public JavaCompiler getSystemJavaCompiler() {
        Class<?> clazz;
        try {
            if (this.isJava9Compatible) {
                clazz = this.isolatedToolsLoader.loadClass("javax.tools.ToolProvider");
                try {
                    return (JavaCompiler)clazz.getDeclaredMethod("getSystemJavaCompiler", new Class[0]).invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    this.cannotCreateJavaCompiler(e);
                }
            } else {
                clazz = this.isolatedToolsLoader.loadClass(DEFAULT_COMPILER_IMPL_NAME);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load class 'com.sun.tools.javac.api.JavacTool");
        }
        return DirectInstantiator.instantiate(clazz.asSubclass(JavaCompiler.class), new Object[0]);
    }

    private void cannotCreateJavaCompiler(Exception e) {
        throw new IllegalStateException("Could not create system Java compiler", e);
    }
}

