/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.quark.Quark;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParseError;

public abstract class RoslynRecipe
extends ScanningRecipe<Accumulator> {
    public int maxCycles() {
        return 1;
    }

    public abstract String getRecipeId();

    public abstract String getNugetPackageName();

    public abstract String getNugetPackageVersion();

    public Accumulator getInitialValue(ExecutionContext executionContext) {
        Context ctx = new Context(executionContext);
        ctx.addRecipeInBatch((Recipe)this);
        ctx.trySetAsFirstRecipeInBatch((Recipe)this);
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                Context ctx = Context.wrap(executionContext);
                if (tree instanceof SourceFile && !(tree instanceof Quark) && !(tree instanceof ParseError) && !tree.getClass().getName().equals("org.openrewrite.java.tree.J$CompilationUnit")) {
                    SourceFile sourceFile = (SourceFile)tree;
                    if (ctx.isFirstRecipe((Recipe)RoslynRecipe.this)) {
                        ctx.writeSource(sourceFile);
                    }
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext executionContext) {
        Context ctx = Context.wrap(executionContext);
        if (ctx.isLastRecipe((Recipe)this)) {
            this.runRoslynRecipe(ctx);
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                Context ctx = Context.wrap(executionContext);
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    return ctx.getModifiedSource(sourceFile);
                }
                return tree;
            }
        };
    }

    private String getRoslynRecipeRunnerCommand(Context ctx) {
        List<RoslynRecipe> recipes = ctx.getRecipesInBatch();
        String nugetPackagesArg = recipes.stream().collect(Collectors.toMap(RoslynRecipe::getNugetPackageName, RoslynRecipe::getNugetPackageVersion, (v1, v2) -> v1.compareTo((String)v2) > 0 ? v1 : v2, LinkedHashMap::new)).entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).map(x -> "--package " + x).collect(Collectors.joining(" "));
        String recipeIdsArg = recipes.stream().map(RoslynRecipe::getRecipeId).distinct().map(id -> "--id " + id).collect(Collectors.joining(" "));
        Path codeDir = ctx.getCodeDir();
        String recipeCommand = "dotnet ${exec} run-recipe --solution ${solution} ${package} ${recipeId}";
        recipeCommand = recipeCommand.replace("${exec}", Objects.requireNonNull(this.getRoslynRecipeRunnerExecutable()));
        recipeCommand = recipeCommand.replace("${solution}", Objects.requireNonNull(codeDir.toString()));
        recipeCommand = recipeCommand.replace("${package}", Objects.requireNonNull(nugetPackagesArg));
        recipeCommand = recipeCommand.replace("${recipeId}", Objects.requireNonNull(recipeIdsArg));
        return recipeCommand;
    }

    private List<String> toCommandArguments(String command) {
        ArrayList<String> args = new ArrayList<String>();
        for (String part : command.split(" ")) {
            part = part.trim();
            args.add(part);
        }
        return args;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runRoslynRecipe(Context ctx) {
        String content;
        HashMap<String, String> env = new HashMap<String, String>();
        String command = this.getRoslynRecipeRunnerCommand(ctx);
        Path out = null;
        Path err = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(this.toCommandArguments(command));
            builder.directory(ctx.getCodeDir().toFile());
            builder.environment().put("TERM", "dumb");
            env.forEach(builder.environment()::put);
            out = Files.createTempFile(WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory(), "roslyn", null, new FileAttribute[0]);
            err = Files.createTempFile(WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory(), "roslyn", null, new FileAttribute[0]);
            builder.redirectOutput(ProcessBuilder.Redirect.to(out.toFile()));
            builder.redirectError(ProcessBuilder.Redirect.to(err.toFile()));
            Process process = builder.start();
            if (!process.waitFor(5L, TimeUnit.MINUTES)) {
                throw new RuntimeException(String.format("Command '%s' timed out after 5 minutes", String.join((CharSequence)" ", command)));
            }
            if (process.exitValue() != 0) {
                String error = "Command failed: " + String.join((CharSequence)" ", command);
                if (Files.exists(err, new LinkOption[0])) {
                    error = error + "\n" + new String(Files.readAllBytes(err));
                }
                error = error + "\nCommand:" + command;
                throw new RuntimeException(error);
            }
            ctx.detectModifiedFiles();
            if (out != null) {
                content = new String(Files.readAllBytes(out));
                System.out.println(content);
                out.toFile().delete();
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                String content2;
                if (out != null) {
                    content2 = new String(Files.readAllBytes(out));
                    System.out.println(content2);
                    out.toFile().delete();
                }
                if (err == null) throw throwable;
                content2 = new String(Files.readAllBytes(err));
                System.out.println(content2);
                err.toFile().delete();
                throw throwable;
            }
        }
        if (err == null) return;
        content = new String(Files.readAllBytes(err));
        System.out.println(content);
        err.toFile().delete();
        return;
    }

    private String getRoslynRecipeRunnerExecutable() {
        String executable = System.getenv("ROSLYN_RECIPE_EXECUTABLE");
        if (executable == null) {
            throw new IllegalStateException("ROSLYN_RECIPE_EXECUTABLE environment variable not set");
        }
        if (!executable.endsWith(".dll")) {
            executable = RoslynRecipe.ensureTrailingSeparator(executable) + "Rewrite.Server.dll";
        }
        return executable;
    }

    public static String ensureTrailingSeparator(String path) {
        if (path == null || path.isEmpty()) {
            return File.separator;
        }
        String separator = File.separator;
        if (path.endsWith("/") || path.endsWith("\\")) {
            if (!path.endsWith(separator)) {
                path = path.substring(0, path.length() - 1) + separator;
            }
            return path;
        }
        return path + separator;
    }

    private static class Context
    implements ExecutionContext {
        private static final String FIRST_RECIPE = RoslynRecipe.class.getName() + ".FIRST_RECIPE";
        private static final String ORIGINAL_FILE_TIMESTAMPS = RoslynRecipe.class.getName() + ".ORIGINAL_FILE_TIMESTAMPS";
        private static final String MODIFIED_FILES = RoslynRecipe.class.getName() + ".MODIFIED_FILES";
        private static final String RECIPE_LIST = RoslynRecipe.class.getName() + ".RECIPE_LIST";
        ExecutionContext ctx;

        public Context(ExecutionContext executionContextContext) {
            this.ctx = executionContextContext;
            WorkingDirectoryExecutionContextView.view((ExecutionContext)this.ctx).getWorkingDirectory();
        }

        public static Context wrap(ExecutionContext context) {
            return new Context(context);
        }

        public void trySetAsFirstRecipeInBatch(Recipe recipe) {
            this.ctx.computeMessageIfAbsent(FIRST_RECIPE, x -> recipe);
        }

        public Map<Path, Long> getBeforeModificationTimestamps() {
            return (Map)this.ctx.computeMessageIfAbsent(ORIGINAL_FILE_TIMESTAMPS, x -> new HashMap());
        }

        public Set<Path> getModifiedFiles() {
            return (Set)this.ctx.computeMessageIfAbsent(MODIFIED_FILES, x -> new LinkedHashSet());
        }

        public boolean isFirstRecipe(Recipe recipe) {
            Recipe firstRecipe = (Recipe)this.ctx.getMessage(FIRST_RECIPE);
            return recipe == firstRecipe;
        }

        public Path getCodeDir() {
            Path workingDirectoryRoot = (Path)this.ctx.getMessage("org.openrewrite.scheduling.workingDirectory");
            if (workingDirectoryRoot == null) {
                WorkingDirectoryExecutionContextView.view((ExecutionContext)this.ctx).getWorkingDirectory();
                workingDirectoryRoot = (Path)this.ctx.getMessage("org.openrewrite.scheduling.workingDirectory");
            }
            assert (workingDirectoryRoot != null);
            return Optional.of(workingDirectoryRoot).map(d -> d.resolve("repo")).map(d -> {
                try {
                    if (!Files.exists(d, new LinkOption[0])) {
                        return Files.createDirectory(d, new FileAttribute[0]).toRealPath(new LinkOption[0]);
                    }
                    return d.toRealPath(new LinkOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).orElseThrow(() -> new IllegalStateException("Failed to create code working directory"));
        }

        boolean isLastRecipe(Recipe recipe) {
            List recipes = (List)this.ctx.getMessage(RECIPE_LIST, new ArrayList());
            int index = recipes.indexOf(recipe);
            return index == recipes.size() - 1;
        }

        public List<RoslynRecipe> getRecipesInBatch() {
            return (List)this.ctx.computeMessageIfAbsent(RECIPE_LIST, x -> new ArrayList());
        }

        public void addRecipeInBatch(Recipe recipe) {
            this.ctx.computeMessage(RECIPE_LIST, null, ArrayList::new, (discard, arr) -> {
                arr.add(recipe);
                return arr;
            });
        }

        public boolean wasModified(SourceFile tree) {
            return this.getModifiedFiles().contains(this.getAbsolutePath(tree));
        }

        public Path getAbsolutePath(SourceFile tree) {
            return this.getCodeDir().resolve(tree.getSourcePath());
        }

        public SourceFile getModifiedSource(SourceFile before) {
            if (!this.wasModified(before)) {
                return before;
            }
            return new PlainText(before.getId(), before.getSourcePath(), before.getMarkers(), before.getCharset() != null ? before.getCharset().name() : null, before.isCharsetBomMarked(), before.getFileAttributes(), null, this.readFromDisk(before), Collections.emptyList());
        }

        public void writeSource(SourceFile tree) {
            try {
                Path path = this.getCodeDir().resolve(tree.getSourcePath());
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                PrintOutputCapture.MarkerPrinter markerPrinter = new PrintOutputCapture.MarkerPrinter(){};
                Path written = Files.write(path, tree.printAll(new PrintOutputCapture((Object)0, markerPrinter)).getBytes(tree.getCharset() != null ? tree.getCharset() : StandardCharsets.UTF_8), new OpenOption[0]);
                this.getBeforeModificationTimestamps().put(written, Files.getLastModifiedTime(written, new LinkOption[0]).toMillis());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private String readFromDisk(SourceFile tree) {
            try {
                Path path = this.getAbsolutePath(tree);
                return tree.getCharset() != null ? new String(Files.readAllBytes(path), tree.getCharset()) : new String(Files.readAllBytes(path));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void detectModifiedFiles() {
            Set<Path> modifiedFiles = this.getModifiedFiles();
            for (Map.Entry<Path, Long> entry : this.getBeforeModificationTimestamps().entrySet()) {
                Path path = entry.getKey();
                if (Files.exists(path, new LinkOption[0]) && Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() <= entry.getValue()) continue;
                modifiedFiles.add(path);
            }
        }

        public Map<String, @Nullable Object> getMessages() {
            return this.ctx.getMessages();
        }

        public void putMessage(String key, @Nullable Object value) {
            this.ctx.putMessage(key, value);
        }

        public <T> @Nullable T getMessage(String key) {
            return (T)this.ctx.getMessage(key);
        }

        public <T> @Nullable T pollMessage(String key) {
            return (T)this.ctx.pollMessage(key);
        }

        public Consumer<Throwable> getOnError() {
            return this.ctx.getOnError();
        }

        public BiConsumer<Throwable, ExecutionContext> getOnTimeout() {
            return this.ctx.getOnTimeout();
        }
    }

    public static class Accumulator {
        @Generated
        public String toString() {
            return "RoslynRecipe.Accumulator()";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public Accumulator() {
        }
    }
}

