/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import org.openrewrite.shaded.jgit.annotations.Nullable;
import org.openrewrite.shaded.jgit.errors.ConfigInvalidException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.Config;
import org.openrewrite.shaded.jgit.util.FS;
import org.openrewrite.shaded.jgit.util.IO;
import org.openrewrite.shaded.jgit.util.RawParseUtils;

public class CommitConfig {
    public static final Config.SectionParser<CommitConfig> KEY = CommitConfig::new;
    private static final Charset DEFAULT_COMMIT_MESSAGE_ENCODING = StandardCharsets.UTF_8;
    private String i18nCommitEncoding;
    private String commitTemplatePath;

    private CommitConfig(Config rc) {
        this.commitTemplatePath = rc.getString("commit", null, "template");
        this.i18nCommitEncoding = rc.getString("i18n", null, "commitEncoding");
    }

    @Nullable
    public String getCommitTemplatePath() {
        return this.commitTemplatePath;
    }

    @Nullable
    public String getCommitEncoding() {
        return this.i18nCommitEncoding;
    }

    @Nullable
    public String getCommitTemplateContent() throws FileNotFoundException, IOException, ConfigInvalidException {
        if (this.commitTemplatePath == null) {
            return null;
        }
        File commitTemplateFile = this.commitTemplatePath.startsWith("~/") ? FS.DETECTED.resolve(FS.DETECTED.userHome(), this.commitTemplatePath.substring(2)) : FS.DETECTED.resolve(null, this.commitTemplatePath);
        Charset commitMessageEncoding = this.getEncoding();
        return RawParseUtils.decode(commitMessageEncoding, IO.readFully(commitTemplateFile));
    }

    private Charset getEncoding() throws ConfigInvalidException {
        Charset commitMessageEncoding = DEFAULT_COMMIT_MESSAGE_ENCODING;
        if (this.i18nCommitEncoding == null) {
            return null;
        }
        try {
            commitMessageEncoding = Charset.forName(this.i18nCommitEncoding);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().invalidEncoding, this.i18nCommitEncoding), e);
        }
        return commitMessageEncoding;
    }
}

