/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.LatestRelease;

public class ExactVersion
extends LatestRelease {
    String version;

    public ExactVersion(String pattern) {
        super(pattern);
        this.version = pattern;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return this.version.equals(version);
    }

    public static Validated<ExactVersion> build(String pattern) {
        int hyphenIndex = pattern.indexOf(45);
        String versionOnly = hyphenIndex == -1 ? pattern : pattern.substring(0, hyphenIndex);
        if (versionOnly.startsWith("latest") || versionOnly.contains("x") || versionOnly.contains("^") || versionOnly.contains("~") || versionOnly.contains(" ")) {
            return Validated.invalid("exactVersion", pattern, "not an exact version number");
        }
        return Validated.valid("exactVersion", new ExactVersion(pattern));
    }
}

