/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openrewrite.Changeset;
import org.openrewrite.DataTable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RecipeRun {
    private final Changeset changeset;
    private final Map<DataTable<?>, List<?>> dataTables;

    @Nullable
    public DataTable<?> getDataTable(String name) {
        for (DataTable<?> dataTable : this.dataTables.keySet()) {
            if (!dataTable.getName().equals(name)) continue;
            return dataTable;
        }
        return null;
    }

    @Nullable
    public <E> List<E> getDataTableRows(String name) {
        for (Map.Entry<DataTable<?>, List<?>> dataTableAndRows : this.dataTables.entrySet()) {
            if (!dataTableAndRows.getKey().getName().equals(name)) continue;
            return dataTableAndRows.getValue();
        }
        return Collections.emptyList();
    }

    public RecipeRun(Changeset changeset, Map<DataTable<?>, List<?>> dataTables) {
        this.changeset = changeset;
        this.dataTables = dataTables;
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    public Map<DataTable<?>, List<?>> getDataTables() {
        return this.dataTables;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeRun)) {
            return false;
        }
        RecipeRun other = (RecipeRun)o;
        Changeset this$changeset = this.getChangeset();
        Changeset other$changeset = other.getChangeset();
        if (this$changeset == null ? other$changeset != null : !this$changeset.equals(other$changeset)) {
            return false;
        }
        Map<DataTable<?>, List<?>> this$dataTables = this.getDataTables();
        Map<DataTable<?>, List<?>> other$dataTables = other.getDataTables();
        return !(this$dataTables == null ? other$dataTables != null : !((Object)this$dataTables).equals(other$dataTables));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Changeset $changeset = this.getChangeset();
        result = result * 59 + ($changeset == null ? 43 : $changeset.hashCode());
        Map<DataTable<?>, List<?>> $dataTables = this.getDataTables();
        result = result * 59 + ($dataTables == null ? 43 : ((Object)$dataTables).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "RecipeRun(changeset=" + this.getChangeset() + ", dataTables=" + this.getDataTables() + ")";
    }

    @NonNull
    public RecipeRun withChangeset(Changeset changeset) {
        return this.changeset == changeset ? this : new RecipeRun(changeset, this.dataTables);
    }

    @NonNull
    public RecipeRun withDataTables(Map<DataTable<?>, List<?>> dataTables) {
        return this.dataTables == dataTables ? this : new RecipeRun(this.changeset, dataTables);
    }
}

