/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.UUID;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public final class ParseExceptionResult
implements Marker {
    private final UUID id;
    private final String parserType;
    private final String exceptionType;
    private final String message;
    @Nullable
    private final String treeType;

    public static ParseExceptionResult build(Class<? extends Parser> parserClass, Throwable t, @Nullable String message) {
        String simpleName = t.getClass().getSimpleName();
        return new ParseExceptionResult(Tree.randomId(), parserClass.getSimpleName(), !StringUtils.isBlank(simpleName) ? simpleName : t.getClass().getName(), (message != null ? message : "") + ExceptionUtils.sanitizeStackTrace(t, parserClass), null);
    }

    public static ParseExceptionResult build(Parser parser, Throwable t, @Nullable String message) {
        return ParseExceptionResult.build(parser.getClass(), t, message);
    }

    public static ParseExceptionResult build(Parser parser, Throwable t) {
        return ParseExceptionResult.build(parser.getClass(), t, null);
    }

    public ParseExceptionResult(UUID id, String parserType, String exceptionType, String message, @Nullable String treeType) {
        this.id = id;
        this.parserType = parserType;
        this.exceptionType = exceptionType;
        this.message = message;
        this.treeType = treeType;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getParserType() {
        return this.parserType;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getTreeType() {
        return this.treeType;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseExceptionResult)) {
            return false;
        }
        ParseExceptionResult other = (ParseExceptionResult)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$parserType = this.getParserType();
        String other$parserType = other.getParserType();
        if (this$parserType == null ? other$parserType != null : !this$parserType.equals(other$parserType)) {
            return false;
        }
        String this$exceptionType = this.getExceptionType();
        String other$exceptionType = other.getExceptionType();
        if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$treeType = this.getTreeType();
        String other$treeType = other.getTreeType();
        return !(this$treeType == null ? other$treeType != null : !this$treeType.equals(other$treeType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $parserType = this.getParserType();
        result = result * 59 + ($parserType == null ? 43 : $parserType.hashCode());
        String $exceptionType = this.getExceptionType();
        result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $treeType = this.getTreeType();
        result = result * 59 + ($treeType == null ? 43 : $treeType.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "ParseExceptionResult(id=" + this.getId() + ", parserType=" + this.getParserType() + ", exceptionType=" + this.getExceptionType() + ", message=" + this.getMessage() + ", treeType=" + this.getTreeType() + ")";
    }

    @NonNull
    public ParseExceptionResult withId(UUID id) {
        return this.id == id ? this : new ParseExceptionResult(id, this.parserType, this.exceptionType, this.message, this.treeType);
    }

    @NonNull
    public ParseExceptionResult withParserType(String parserType) {
        return this.parserType == parserType ? this : new ParseExceptionResult(this.id, parserType, this.exceptionType, this.message, this.treeType);
    }

    @NonNull
    public ParseExceptionResult withExceptionType(String exceptionType) {
        return this.exceptionType == exceptionType ? this : new ParseExceptionResult(this.id, this.parserType, exceptionType, this.message, this.treeType);
    }

    @NonNull
    public ParseExceptionResult withMessage(String message) {
        return this.message == message ? this : new ParseExceptionResult(this.id, this.parserType, this.exceptionType, message, this.treeType);
    }

    @NonNull
    public ParseExceptionResult withTreeType(@Nullable String treeType) {
        return this.treeType == treeType ? this : new ParseExceptionResult(this.id, this.parserType, this.exceptionType, this.message, treeType);
    }
}

