/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.table.DistinctGitProvenance;

public class FindGitProvenance
extends ScanningRecipe<Set<GitProvenance>> {
    private static final UUID DONT_CONSIDER_ID_IN_HASH_CODE = UUID.randomUUID();
    private final DistinctGitProvenance distinct = new DistinctGitProvenance(this);

    @Override
    public String getDisplayName() {
        return "Show Git source control metadata";
    }

    @Override
    public String getDescription() {
        return "List out the contents of each unique `GitProvenance` marker in the set of source files. When everything is working correctly, exactly one such marker should be printed as all source files are expected to come from the same repository / branch / commit hash.";
    }

    @Override
    public Set<GitProvenance> getInitialValue(ExecutionContext ctx) {
        return new HashSet<GitProvenance>();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Set<GitProvenance> provenances) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                sourceFile.getMarkers().findFirst(GitProvenance.class).ifPresent(provenance -> provenances.add(provenance.withId(DONT_CONSIDER_ID_IN_HASH_CODE)));
                return sourceFile;
            }
        };
    }

    @Override
    public Collection<SourceFile> generate(Set<GitProvenance> provenances, ExecutionContext ctx) {
        for (GitProvenance provenance : provenances) {
            this.distinct.insertRow(ctx, new DistinctGitProvenance.Row(provenance.getOrigin(), provenance.getBranch(), provenance.getChange(), provenance.getAutocrlf(), provenance.getEol()));
        }
        return Collections.emptyList();
    }
}

