/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openrewrite.shaded.jgit.api.Git;
import org.openrewrite.shaded.jgit.api.GitCommand;
import org.openrewrite.shaded.jgit.api.MergeResult;
import org.openrewrite.shaded.jgit.api.errors.ConcurrentRefUpdateException;
import org.openrewrite.shaded.jgit.api.errors.GitAPIException;
import org.openrewrite.shaded.jgit.api.errors.JGitInternalException;
import org.openrewrite.shaded.jgit.api.errors.MultipleParentsNotAllowedException;
import org.openrewrite.shaded.jgit.api.errors.NoHeadException;
import org.openrewrite.shaded.jgit.api.errors.NoMessageException;
import org.openrewrite.shaded.jgit.api.errors.UnmergedPathsException;
import org.openrewrite.shaded.jgit.api.errors.WrongRepositoryStateException;
import org.openrewrite.shaded.jgit.dircache.DirCacheCheckout;
import org.openrewrite.shaded.jgit.events.WorkingTreeModifiedEvent;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.AnyObjectId;
import org.openrewrite.shaded.jgit.lib.NullProgressMonitor;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectIdRef;
import org.openrewrite.shaded.jgit.lib.ProgressMonitor;
import org.openrewrite.shaded.jgit.lib.Ref;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.merge.MergeMessageFormatter;
import org.openrewrite.shaded.jgit.merge.MergeStrategy;
import org.openrewrite.shaded.jgit.merge.ResolveMerger;
import org.openrewrite.shaded.jgit.revwalk.RevCommit;
import org.openrewrite.shaded.jgit.revwalk.RevWalk;
import org.openrewrite.shaded.jgit.treewalk.FileTreeIterator;

public class RevertCommand
extends GitCommand<RevCommit> {
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private List<Ref> revertedRefs = new LinkedList<Ref>();
    private MergeResult failingResult;
    private List<String> unmergedPaths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected RevertCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, GitAPIException {
        RevCommit newHead = null;
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                String newMessage;
                ResolveMerger merger;
                RevCommit srcParent;
                RevCommit srcCommit;
                RevCommit headCommit;
                Ref headRef = this.repo.exactRef("HEAD");
                if (headRef == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                newHead = headCommit = revWalk.parseCommit(headRef.getObjectId());
                Iterator<Ref> iterator = this.commits.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return newHead;
                    }
                    Ref src = iterator.next();
                    ObjectId srcObjectId = src.getPeeledObjectId();
                    if (srcObjectId == null) {
                        srcObjectId = src.getObjectId();
                    }
                    if ((srcCommit = revWalk.parseCommit(srcObjectId)).getParentCount() != 1) {
                        throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyRevertCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
                    }
                    srcParent = srcCommit.getParent(0);
                    revWalk.parseHeaders(srcParent);
                    String ourName = this.calculateOurName(headRef);
                    String revertName = String.valueOf(srcCommit.getId().abbreviate(7).name()) + " " + srcCommit.getShortMessage();
                    merger = (ResolveMerger)this.strategy.newMerger(this.repo);
                    merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                    merger.setBase(srcCommit.getTree());
                    merger.setCommitNames(new String[]{"BASE", ourName, revertName});
                    String shortMessage = "Revert \"" + srcCommit.getShortMessage() + "\"";
                    newMessage = String.valueOf(shortMessage) + "\n\n" + "This reverts commit " + srcCommit.getId().getName() + ".\n";
                    if (!merger.merge(headCommit, srcParent)) break;
                    if (!merger.getModifiedFiles().isEmpty()) {
                        this.repo.fireEvent(new WorkingTreeModifiedEvent(merger.getModifiedFiles(), null));
                    }
                    if (AnyObjectId.isEqual(headCommit.getTree().getId(), merger.getResultTreeId())) continue;
                    DirCacheCheckout dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                    dco.setFailOnConflict(true);
                    dco.setProgressMonitor(this.monitor);
                    dco.checkout();
                    Throwable throwable2 = null;
                    Object var19_23 = null;
                    try (Git git = new Git(this.getRepository());){
                        newHead = git.commit().setMessage(newMessage).setReflogComment("revert: " + shortMessage).call();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    this.revertedRefs.add(src);
                    headCommit = newHead;
                }
                this.unmergedPaths = merger.getUnmergedPaths();
                Map<String, ResolveMerger.MergeFailureReason> failingPaths = merger.getFailingPaths();
                this.failingResult = failingPaths != null ? new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcParent.getId()}, MergeResult.MergeStatus.FAILED, this.strategy, merger.getMergeResults(), failingPaths, null) : new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcParent.getId()}, MergeResult.MergeStatus.CONFLICTING, this.strategy, merger.getMergeResults(), failingPaths, null);
                if (merger.failed()) return null;
                if (this.unmergedPaths.isEmpty()) return null;
                String message = new MergeMessageFormatter().formatWithConflicts(newMessage, merger.getUnmergedPaths());
                this.repo.writeRevertHead(srcCommit.getId());
                this.repo.writeMergeCommitMsg(message);
                return null;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfRevertCommand, e), e);
        }
    }

    public RevertCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public RevertCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public RevertCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public RevertCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }

    public List<Ref> getRevertedRefs() {
        return this.revertedRefs;
    }

    public MergeResult getFailingResult() {
        return this.failingResult;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public RevertCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public RevertCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }
}

