/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openrewrite.Contributor;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.style.NamedStyles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningLoader
implements ResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathScanningLoader.class);
    private final LinkedHashSet<Recipe> recipes = new LinkedHashSet();
    private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
    private final LinkedHashSet<RecipeDescriptor> recipeDescriptors = new LinkedHashSet();
    private final List<CategoryDescriptor> categoryDescriptors = new ArrayList<CategoryDescriptor>();
    private final Map<String, List<Contributor>> recipeAttributions = new HashMap<String, List<Contributor>>();
    private final Map<String, List<RecipeExample>> recipeExamples = new HashMap<String, List<RecipeExample>>();

    public ClasspathScanningLoader(Properties properties, String[] acceptPackages) {
        this.scanClasses(new ClassGraph().acceptPackages(acceptPackages), this.getClass().getClassLoader());
        this.scanYaml(new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}), properties, Collections.emptyList(), null);
    }

    public ClasspathScanningLoader(Properties properties, ClassLoader classLoader) {
        this.scanClasses(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}), classLoader);
        this.scanYaml(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties, Collections.emptyList(), classLoader);
    }

    public ClasspathScanningLoader(Path jar, Properties properties, Collection<? extends ResourceLoader> dependencyResourceLoaders, ClassLoader classLoader) {
        String jarName = jar.toFile().getName();
        this.scanClasses(new ClassGraph().acceptJars(new String[]{jarName}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}), classLoader);
        this.scanYaml(new ClassGraph().acceptJars(new String[]{jarName}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties, dependencyResourceLoaders, classLoader);
    }

    public static ClasspathScanningLoader onlyYaml(Properties properties) {
        ClasspathScanningLoader classpathScanningLoader = new ClasspathScanningLoader();
        classpathScanningLoader.scanYaml(new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}), properties, Collections.emptyList(), null);
        return classpathScanningLoader;
    }

    private ClasspathScanningLoader() {
    }

    private void scanYaml(ClassGraph classGraph, Properties properties, Collection<? extends ResourceLoader> dependencyResourceLoaders, @Nullable ClassLoader classLoader) {
        try (ScanResult scanResult = classGraph.enableMemoryMapping().scan();){
            ArrayList yamlResourceLoaders = new ArrayList();
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> yamlResourceLoaders.add(new YamlResourceLoader(input, res.getURI(), properties, classLoader, dependencyResourceLoaders)));
            scanResult.getResourcesWithExtension("yaml").forEachInputStreamIgnoringIOException((res, input) -> yamlResourceLoaders.add(new YamlResourceLoader(input, res.getURI(), properties, classLoader, dependencyResourceLoaders)));
            for (YamlResourceLoader resourceLoader : yamlResourceLoaders) {
                this.recipes.addAll(resourceLoader.listRecipes());
                this.categoryDescriptors.addAll(resourceLoader.listCategoryDescriptors());
                this.styles.addAll(resourceLoader.listStyles());
                this.recipeAttributions.putAll(resourceLoader.listContributors());
                this.recipeExamples.putAll(resourceLoader.listRecipeExamples());
            }
            for (YamlResourceLoader resourceLoader : yamlResourceLoaders) {
                this.recipeDescriptors.addAll(resourceLoader.listRecipeDescriptors(this.recipes, this.recipeAttributions, this.recipeExamples));
            }
        }
    }

    private void scanClasses(ClassGraph classGraph, ClassLoader classLoader) {
        try (ScanResult result = classGraph.ignoreClassVisibility().overrideClassLoaders(new ClassLoader[]{classLoader}).scan();){
            this.configureRecipes(result, Recipe.class.getName());
            this.configureRecipes(result, ScanningRecipe.class.getName());
            for (ClassInfo classInfo : result.getSubclasses(NamedStyles.class.getName())) {
                Class styleClass = classInfo.loadClass();
                try {
                    Constructor<?> constructor = RecipeIntrospectionUtils.getZeroArgsConstructor(styleClass);
                    if (constructor == null) continue;
                    constructor.setAccessible(true);
                    this.styles.add((NamedStyles)constructor.newInstance(new Object[0]));
                }
                catch (Throwable e) {
                    logger.warn("Unable to configure {}", (Object)styleClass.getName(), (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureRecipes(ScanResult result, String className) {
        for (ClassInfo classInfo : result.getSubclasses(className)) {
            Class recipeClass = classInfo.loadClass();
            if (recipeClass.getName().equals(DeclarativeRecipe.class.getName()) || (recipeClass.getModifiers() & 0x400) != 0) continue;
            Timer.Builder builder = Timer.builder((String)"rewrite.scan.configure.recipe");
            Timer.Sample sample = Timer.start();
            try {
                Recipe recipe = RecipeIntrospectionUtils.constructRecipe(recipeClass);
                this.recipeDescriptors.add(recipe.getDescriptor());
                this.recipes.add(recipe);
                MetricsHelper.successTags(builder.tags(new String[]{"recipe", "elided"}));
            }
            catch (Throwable e) {
                MetricsHelper.errorTags(builder.tags(new String[]{"recipe", recipeClass.getName()}), e);
                logger.warn("Unable to configure {}", (Object)recipeClass.getName(), (Object)e);
            }
            finally {
                sample.stop(builder.register((MeterRegistry)Metrics.globalRegistry));
            }
        }
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.recipes;
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.recipeDescriptors;
    }

    @Override
    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.categoryDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.styles;
    }

    @Override
    public Map<String, List<RecipeExample>> listRecipeExamples() {
        return this.recipeExamples;
    }

    @Override
    public Map<String, List<Contributor>> listContributors() {
        return this.recipeAttributions;
    }
}

