/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceReader {
    public RecipeMarketplace fromCsv(@Language(value="csv") String csv) {
        return this.fromCsv(new StringReader(csv));
    }

    public RecipeMarketplace fromCsv(Path csv) {
        try {
            return this.fromCsv(Files.newBufferedReader(csv));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read from CSV", e);
        }
    }

    public RecipeMarketplace fromCsv(InputStream csv) {
        return this.fromCsv(new InputStreamReader(csv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeMarketplace fromCsv(Reader csv) {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setLineSeparatorDetectionEnabled(true);
        settings.setHeaderExtractionEnabled(false);
        settings.setNullValue("");
        settings.setDelimiterDetectionEnabled(true, new char[]{',', '\t', ';'});
        settings.setMaxCharsPerColumn(-1);
        CsvParser parser = new CsvParser(settings);
        parser.beginParsing(csv);
        try {
            String[] row;
            RecipeMarketplace marketplace = new RecipeMarketplace();
            List<NamedColumn> headers = null;
            while ((row = parser.parseNext()) != null) {
                if (row.length == 0 || row.length == 1 && row[0] == null) continue;
                if (headers == null) {
                    headers = this.parseHeaders(row);
                    continue;
                }
                this.readRecipe(row, marketplace, headers);
            }
            RecipeMarketplace recipeMarketplace = marketplace;
            return recipeMarketplace;
        }
        finally {
            parser.stopParsing();
        }
    }

    private List<NamedColumn> parseHeaders(@Nullable String[] row) {
        ArrayList<NamedColumn> headers = new ArrayList<NamedColumn>();
        for (String headerName : row) {
            if (headerName == null) continue;
            headerName = headerName.trim();
            headers.add(Column.fromString(headerName));
        }
        return headers;
    }

    private void readRecipe(@Nullable String[] row, RecipeMarketplace marketplace, List<NamedColumn> headers) {
        String name = null;
        String displayName = null;
        String description = null;
        Duration estimatedEffortPerOccurrence = null;
        String ecosystem = null;
        String packageName = null;
        String version = null;
        String team = null;
        ArrayList<String> categories = new ArrayList<String>();
        TreeMap<Integer, RecipeListing.Option> options = new TreeMap<Integer, RecipeListing.Option>();
        block16: for (int i = 0; i < row.length && i < headers.size(); ++i) {
            String value = row[i];
            if (value != null && StringUtils.isBlank(value = value.trim())) {
                value = null;
            }
            NamedColumn column = headers.get(i);
            switch (column.getColumn().ordinal()) {
                case 0: {
                    name = value;
                    continue block16;
                }
                case 1: {
                    displayName = value;
                    continue block16;
                }
                case 2: {
                    description = value;
                    continue block16;
                }
                case 3: {
                    if (value == null) continue block16;
                    try {
                        estimatedEffortPerOccurrence = Duration.parse(value);
                        continue block16;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Invalid duration format for estimatedEffortPerOccurrence: '" + value + "'. Expected ISO-8601 duration format (e.g., PT5M, PT1H)", e);
                    }
                }
                case 4: {
                    if (value == null) continue block16;
                    categories.add(value);
                    continue block16;
                }
                case 5: {
                    ecosystem = value;
                    continue block16;
                }
                case 6: {
                    packageName = value;
                    continue block16;
                }
                case 7: {
                    version = value;
                    continue block16;
                }
                case 8: {
                    team = value;
                    continue block16;
                }
                case 9: {
                    if (value == null) continue block16;
                    int optionIndex = column.getIndex();
                    options.computeIfAbsent(optionIndex, k -> new RecipeListing.Option()).setName(value);
                    continue block16;
                }
                case 10: {
                    if (value == null) continue block16;
                    int optionIndex = column.getIndex();
                    options.computeIfAbsent(optionIndex, k -> new RecipeListing.Option()).setDisplayName(value);
                    continue block16;
                }
                case 11: {
                    if (value == null) continue block16;
                    int optionIndex = column.getIndex();
                    options.computeIfAbsent(optionIndex, k -> new RecipeListing.Option()).setDescription(value);
                    continue block16;
                }
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("CSV file must contain a column named 'name' and each row must have a value for it");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("CSV file must contain a column named 'packageName' and each row must have a value for it");
        }
        if (ecosystem == null) {
            throw new IllegalArgumentException("CSV file must contain a column named 'ecosystem' and each row must have a value for it");
        }
        RecipeBundle bundle = new RecipeBundle(ecosystem.toLowerCase(), packageName, version, team);
        RecipeListing listing = new RecipeListing(marketplace, name, displayName != null ? displayName : name, description != null ? description : "", estimatedEffortPerOccurrence, new ArrayList(options.values()), bundle);
        Collections.reverse(categories);
        marketplace.install(listing, categories);
    }

    private static enum Column {
        NAME("name"),
        DISPLAY_NAME("displayName"),
        DESCRIPTION("description"),
        ESTIMATED_EFFORT_PER_OCCURRENCE("estimatedEffortPerOccurrence"),
        CATEGORY("category"),
        ECOSYSTEM("ecosystem"),
        PACKAGE_NAME("packageName"),
        VERSION("version"),
        TEAM("team"),
        OPTION_NAME("optionName"),
        OPTION_DISPLAY_NAME("optionDisplayName"),
        OPTION_DESCRIPTION("optionDescription"),
        UNKNOWN("_unknown");

        private final String columnName;
        private static final Pattern OPTION_NAME_PATTERN;
        private static final Pattern OPTION_DISPLAY_NAME_PATTERN;
        private static final Pattern OPTION_DESCRIPTION_PATTERN;

        public static NamedColumn fromString(String key) {
            String lowerKey = key.toLowerCase();
            if (lowerKey.startsWith("category")) {
                return new NamedColumn(CATEGORY, key, -1);
            }
            Matcher optionNameMatcher = OPTION_NAME_PATTERN.matcher(key);
            if (optionNameMatcher.matches()) {
                int index = Integer.parseInt(optionNameMatcher.group(1));
                return new NamedColumn(OPTION_NAME, key, index);
            }
            Matcher optionDisplayNameMatcher = OPTION_DISPLAY_NAME_PATTERN.matcher(key);
            if (optionDisplayNameMatcher.matches()) {
                int index = Integer.parseInt(optionDisplayNameMatcher.group(1));
                return new NamedColumn(OPTION_DISPLAY_NAME, key, index);
            }
            Matcher optionDescriptionMatcher = OPTION_DESCRIPTION_PATTERN.matcher(key);
            if (optionDescriptionMatcher.matches()) {
                int index = Integer.parseInt(optionDescriptionMatcher.group(1));
                return new NamedColumn(OPTION_DESCRIPTION, key, index);
            }
            for (Column column : Column.values()) {
                if (!column.columnName.equalsIgnoreCase(key)) continue;
                return new NamedColumn(column, key, -1);
            }
            return new NamedColumn(UNKNOWN, key, -1);
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        private Column(String columnName) {
            this.columnName = columnName;
        }

        static {
            OPTION_NAME_PATTERN = Pattern.compile("option(\\d+)Name", 2);
            OPTION_DISPLAY_NAME_PATTERN = Pattern.compile("option(\\d+)DisplayName", 2);
            OPTION_DESCRIPTION_PATTERN = Pattern.compile("option(\\d+)Description", 2);
        }
    }

    private static final class NamedColumn {
        private final Column column;
        private final String headerName;
        private final int index;

        @Generated
        public NamedColumn(Column column, String headerName, int index) {
            this.column = column;
            this.headerName = headerName;
            this.index = index;
        }

        @Generated
        public Column getColumn() {
            return this.column;
        }

        @Generated
        public String getHeaderName() {
            return this.headerName;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedColumn)) {
                return false;
            }
            NamedColumn other = (NamedColumn)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            Column this$column = this.getColumn();
            Column other$column = other.getColumn();
            if (this$column == null ? other$column != null : !((Object)((Object)this$column)).equals((Object)other$column)) {
                return false;
            }
            String this$headerName = this.getHeaderName();
            String other$headerName = other.getHeaderName();
            return !(this$headerName == null ? other$headerName != null : !this$headerName.equals(other$headerName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            Column $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : ((Object)((Object)$column)).hashCode());
            String $headerName = this.getHeaderName();
            result = result * 59 + ($headerName == null ? 43 : $headerName.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RecipeMarketplaceReader.NamedColumn(column=" + (Object)((Object)this.getColumn()) + ", headerName=" + this.getHeaderName() + ", index=" + this.getIndex() + ")";
        }
    }
}

