/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class PlainTextPrinter<P>
extends PlainTextVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> TEXT_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    @Override
    public PlainText visitText(PlainText text, PrintOutputCapture<P> p) {
        this.visitMarkableText(text.getMarkers(), text.getText(), p);
        for (PlainText.Snippet snippet : text.getSnippets()) {
            this.setCursor(new Cursor(this.getCursor(), snippet));
            this.visitSnippet(snippet, p);
            this.setCursor(this.getCursor().getParent());
        }
        return text;
    }

    @Override
    public PlainText.Snippet visitSnippet(PlainText.Snippet text, PrintOutputCapture<P> p) {
        this.visitMarkableText(text.getMarkers(), text.getText(), p);
        return text;
    }

    private void visitMarkableText(Markers markers, String text, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), marker), TEXT_MARKER_WRAPPER));
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), marker), TEXT_MARKER_WRAPPER));
        }
        p.append(text);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), marker), TEXT_MARKER_WRAPPER));
        }
    }
}

