/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.jgit.diff.RawText;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PlainTextParser
implements Parser {
    public static PlainText convert(SourceFile sourceFile) {
        if (sourceFile instanceof PlainText) {
            return (PlainText)sourceFile;
        }
        PlainText text = (PlainText)PlainTextParser.builder().build().parse(sourceFile.printAll(new PrintOutputCapture<Integer>(0, PrintOutputCapture.MarkerPrinter.SANITIZED))).findFirst().orElseThrow(() -> new IllegalStateException("Failed to parse as plain text")).withSourcePath(sourceFile.getSourcePath()).withFileAttributes(sourceFile.getFileAttributes()).withCharsetBomMarked(sourceFile.isCharsetBomMarked()).withId(sourceFile.getId()).withMarkers(sourceFile.getMarkers().withMarkers(PlainTextParser.gatherMarkers(sourceFile)));
        if (sourceFile.getCharset() != null) {
            text = (PlainText)text.withCharset(sourceFile.getCharset());
        }
        return text;
    }

    @Override
    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view(ctx).getParsingListener();
        return StreamSupport.stream(sources.spliterator(), false).map(input -> {
            Path path = input.getRelativePath(relativeTo);
            parsingListener.startedParsing((Parser.Input)input);
            try {
                EncodingDetectingInputStream is = input.getSource(ctx);
                String sourceStr = is.readFully();
                PlainText plainText = PlainText.builder().sourcePath(path).charsetName(is.getCharset().name()).charsetBomMarked(is.isCharsetBomMarked()).fileAttributes(input.getFileAttributes()).text(sourceStr).build();
                parsingListener.parsed((Parser.Input)input, plainText);
                return plainText;
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build(this, input, relativeTo, ctx, t);
            }
        });
    }

    @Override
    public boolean accept(Path path) {
        boolean bl;
        block8: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                boolean bl2 = bl = !RawText.isBinary((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.txt");
    }

    public static Builder builder() {
        return new Builder();
    }

    private static List<Marker> gatherMarkers(final SourceFile sourceFile) {
        return new TreeVisitor<Tree, List<Marker>>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, List<Marker> markers) {
                if (tree != null && tree != sourceFile) {
                    tree.getMarkers().getMarkers().forEach(marker -> {
                        if (marker instanceof SearchResult || marker instanceof Markup) {
                            markers.add((Marker)marker);
                        }
                    });
                }
                return super.visit(tree, markers);
            }
        }.reduce(sourceFile, new ArrayList<Marker>(sourceFile.getMarkers().getMarkers()));
    }

    public static class Builder
    extends Parser.Builder {
        private @Nullable Collection<PathMatcher> plainTextMasks;

        public Builder() {
            super(PlainText.class);
        }

        public Builder plainTextMasks(Collection<PathMatcher> plainTextMasks) {
            this.plainTextMasks = plainTextMasks;
            return this;
        }

        public Builder plainTextMasks(Path basePath, Iterable<String> plainTextMaskGlobs) {
            return this.plainTextMasks(StreamSupport.stream(plainTextMaskGlobs.spliterator(), false).map(o -> basePath.getFileSystem().getPathMatcher("glob:" + o)).collect(Collectors.toList()));
        }

        @Override
        public PlainTextParser build() {
            if (this.plainTextMasks != null) {
                return new PlainTextParser(){

                    @Override
                    public boolean accept(Path path) {
                        for (PathMatcher matcher : plainTextMasks) {
                            if (!matcher.matches(path)) continue;
                            return true;
                        }
                        if (!path.isAbsolute() && !path.startsWith(File.separator)) {
                            return this.accept(Paths.get("/" + path, new String[0]));
                        }
                        return super.accept(path);
                    }
                };
            }
            return new PlainTextParser();
        }

        @Override
        public String getDslName() {
            return "text";
        }
    }
}

