/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> insertInOrder(@Nullable List<T> ls, T insert, Comparator<T> naturalOrdering) {
        if (ls == null || ls.isEmpty()) {
            return Collections.singletonList(insert);
        }
        ArrayList<T> ordered = new ArrayList<T>(ls);
        ordered.add(insert);
        ordered.sort(naturalOrdering);
        Object comesAfter = null;
        for (Object t : ordered) {
            if (t == insert) break;
            comesAfter = t;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        if (comesAfter == null) {
            newLs.add(0, insert);
        } else {
            for (int i = 0; i < newLs.size(); ++i) {
                if (newLs.get(i) != comesAfter) continue;
                newLs.add(i + 1, insert);
            }
        }
        return newLs;
    }

    public static <T> List<T> insert(@Nullable List<T> ls, @Nullable T t, int index) {
        if (ls == null && t == null) {
            return Collections.emptyList();
        }
        if (t == null) {
            return ls;
        }
        ArrayList<T> newLs = ls == null ? new ArrayList<T>(1) : new ArrayList<T>(ls);
        newLs.add(index, t);
        return newLs;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T> @Nullable List<T> mapLast(@Nullable List<T> ls, Function<T, @Nullable T> mapLast) {
        T newLast;
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        T last = ls.get(ls.size() - 1);
        if (last != (newLast = mapLast.apply(last))) {
            ArrayList<T> newLs = new ArrayList<T>(ls);
            if (newLast == null) {
                newLs.remove(ls.size() - 1);
            } else {
                newLs.set(ls.size() - 1, newLast);
            }
            return newLs;
        }
        return ls;
    }

    public static <T> @Nullable List<T> mapLast(@Nullable List<T> ls, UnaryOperator<@Nullable T> mapLast) {
        return ListUtils.mapLast(ls, mapLast);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T> @Nullable List<T> mapFirst(@Nullable List<T> ls, Function<T, @Nullable T> mapFirst) {
        T newFirst;
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        T first = ls.iterator().next();
        if (first != (newFirst = mapFirst.apply(first))) {
            ArrayList<T> newLs = new ArrayList<T>(ls);
            if (newFirst == null) {
                newLs.remove(0);
            } else {
                newLs.set(0, newFirst);
            }
            return newLs;
        }
        return ls;
    }

    public static <T> @Nullable List<T> mapFirst(@Nullable List<T> ls, UnaryOperator<T> mapFirst) {
        return ListUtils.mapFirst(ls, mapFirst);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T> @Nullable List<T> map(@Nullable List<T> ls, BiFunction<Integer, T, @Nullable T> map) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        List<@Nullable T> newLs = ls;
        boolean nullEncountered = false;
        for (int i = 0; i < ls.size(); ++i) {
            T tree = ls.get(i);
            T newTree = map.apply(i, (Integer)tree);
            if (newTree != tree) {
                if (newLs == ls) {
                    newLs = new ArrayList<T>(ls);
                }
                newLs.set(i, newTree);
            }
            nullEncountered |= newTree == null;
        }
        if (newLs != ls && nullEncountered) {
            while (newLs.remove(null)) {
            }
        }
        return newLs;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T> @Nullable List<T> map(@Nullable List<T> ls, Function<T, @Nullable T> map) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        List<@Nullable T> newLs = ls;
        boolean nullEncountered = false;
        for (int i = 0; i < ls.size(); ++i) {
            T tree = ls.get(i);
            T newTree = map.apply(tree);
            if (newTree != tree) {
                if (newLs == ls) {
                    newLs = new ArrayList<T>(ls);
                }
                newLs.set(i, newTree);
            }
            nullEncountered |= newTree == null;
        }
        if (newLs != ls && nullEncountered) {
            while (newLs.remove(null)) {
            }
        }
        return newLs;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T> @Nullable List<T> map(@Nullable List<T> ls, UnaryOperator<T> map) {
        return ListUtils.map(ls, map);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T> @Nullable List<T> flatMap(@Nullable List<T> ls, BiFunction<Integer, T, @Nullable Object> flatMap) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        List<@Nullable T> newLs = ls;
        int j = 0;
        int i = 0;
        while (i < ls.size()) {
            T tree = ls.get(i);
            Object newTreeOrTrees = flatMap.apply(i, (Integer)tree);
            if (newTreeOrTrees != tree) {
                if (newLs == ls) {
                    newLs = new ArrayList<T>(ls);
                }
                if (newTreeOrTrees instanceof Iterable) {
                    boolean addedTree = false;
                    for (Object newTree : (Iterable)newTreeOrTrees) {
                        if (j >= newLs.size()) {
                            newLs.add(newTree);
                        } else if (!addedTree) {
                            newLs.set(j, newTree);
                        } else {
                            newLs.add(j, newTree);
                        }
                        addedTree = true;
                        ++j;
                    }
                    if (addedTree) {
                        --j;
                    } else {
                        newLs.set(j, null);
                    }
                } else if (j >= newLs.size()) {
                    newLs.add(newTreeOrTrees);
                } else {
                    newLs.set(j, newTreeOrTrees);
                }
            }
            ++i;
            ++j;
        }
        if (newLs != ls) {
            boolean identical = newLs.size() == ls.size();
            for (int i2 = newLs.size() - 1; i2 >= 0; --i2) {
                T newElem = newLs.get(i2);
                boolean bl = identical = identical && newElem == ls.get(i2);
                if (newElem != null) continue;
                newLs.remove(i2);
            }
            if (identical) {
                newLs = ls;
            }
        }
        return newLs;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T> @Nullable List<T> flatMap(@Nullable List<T> ls, Function<T, @Nullable Object> flatMap) {
        return ListUtils.flatMap(ls, (Integer i, T t) -> flatMap.apply(t));
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static <T> @Nullable List<T> filter(@Nullable List<T> ls, Predicate<T> predicate) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        List<T> newLs = ls;
        int j = 0;
        int i = 0;
        while (i < ls.size()) {
            T elem = ls.get(i);
            if (!predicate.test(elem)) {
                if (newLs == ls) {
                    newLs = new ArrayList<T>(ls);
                }
                newLs.remove(j);
                --j;
            }
            ++i;
            ++j;
        }
        return newLs;
    }

    public static <T> List<T> concat(@Nullable List<T> ls, @Nullable T t) {
        if (t == null && ls == null) {
            return Collections.emptyList();
        }
        if (t == null) {
            return ls;
        }
        ArrayList<T> newLs = ls == null ? new ArrayList<T>(1) : new ArrayList<T>(ls);
        newLs.add(t);
        return newLs;
    }

    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    public static <T> @Nullable List<T> concat(@Nullable T t, @Nullable List<T> ls) {
        if (t == null && ls == null) {
            return null;
        }
        if (t == null) {
            return ls;
        }
        ArrayList<T> newLs = ls == null ? new ArrayList<T>(1) : new ArrayList(ls.size() + 1);
        newLs.add(t);
        if (ls != null) {
            newLs.addAll(ls);
        }
        return newLs;
    }

    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    public static <T> @Nullable List<T> concatAll(@Nullable List<T> ls, @Nullable List<? extends T> t) {
        if (ls == null && t == null) {
            return null;
        }
        if (t == null || t.isEmpty()) {
            return ls;
        }
        if (ls == null || ls.isEmpty()) {
            return t;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        newLs.addAll(t);
        return newLs;
    }

    public static <T> List<T> insertAll(@Nullable List<T> ls, int index, @Nullable List<T> t) {
        if (ls == null && t == null) {
            return Collections.emptyList();
        }
        if (t == null || t.isEmpty()) {
            return ls;
        }
        if (ls == null || ls.isEmpty()) {
            return t;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        newLs.addAll(index, t);
        return newLs;
    }

    public static <T> @Nullable List<T> nullIfEmpty(@Nullable List<T> ls) {
        return ls == null || ls.isEmpty() ? null : ls;
    }

    public static <T> T @Nullable [] arrayOrNullIfEmpty(@Nullable List<T> list, T @Nullable [] array) {
        if (list == null || array == null || list.isEmpty()) {
            return null;
        }
        return list.toArray(array);
    }

    public static <T> T @Nullable [] nullIfEmpty(T @Nullable [] array) {
        return array == null || array.length == 0 ? null : array;
    }
}

