/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class TildeRange
extends LatestRelease {
    private static final Pattern TILDE_RANGE_PATTERN = Pattern.compile("~(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?");
    private final String upperExclusive;
    private final String lower;
    private final boolean requireRelease;

    private TildeRange(String lower, String upperExclusive, @Nullable String metadataPattern, boolean requireRelease) {
        super(metadataPattern);
        this.lower = lower;
        this.upperExclusive = upperExclusive;
        this.requireRelease = requireRelease;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return VersionComparator.checkVersion(version, this.getMetadataPattern(), this.requireRelease) && super.compare(currentVersion, version, this.upperExclusive) < 0 && super.compare(currentVersion, version, this.lower) >= 0;
    }

    public static Validated<TildeRange> build(String pattern, @Nullable String metadataPattern) {
        return TildeRange.build(pattern, metadataPattern, false);
    }

    public static Validated<TildeRange> build(String pattern, @Nullable String metadataPattern, boolean requireRelease) {
        String upper;
        String lower;
        Matcher matcher = TILDE_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("tildeRange", pattern, "not a tilde range");
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        String patch = matcher.group(3);
        String micro = matcher.group(4);
        if (minor == null) {
            lower = major;
            upper = Integer.toString(Integer.parseInt(major) + 1);
        } else if (patch == null) {
            lower = major + "." + minor;
            upper = major + "." + (Integer.parseInt(minor) + 1);
        } else if (micro == null) {
            lower = major + "." + minor + "." + patch;
            upper = major + "." + (Integer.parseInt(minor) + 1);
        } else {
            lower = major + "." + minor + "." + patch + "." + micro;
            upper = major + "." + minor + "." + (Integer.parseInt(patch) + 1);
        }
        return Validated.valid("tildeRange", new TildeRange(lower, upper, metadataPattern, requireRelease));
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        Validated<TildeRange> maybeTildeRangeV1 = TildeRange.build(v1, null);
        Validated<TildeRange> maybeTildeRangeV2 = TildeRange.build(v2, null);
        if (maybeTildeRangeV1.isValid() && maybeTildeRangeV2.isValid()) {
            TildeRange tildeRangeV1 = Objects.requireNonNull(maybeTildeRangeV1.getValue());
            TildeRange tildeRangeV2 = Objects.requireNonNull(maybeTildeRangeV2.getValue());
            int compare = super.compare(currentVersion, tildeRangeV1.upperExclusive, tildeRangeV2.upperExclusive);
            if (compare != 0) {
                return compare;
            }
            return super.compare(currentVersion, tildeRangeV1.lower, tildeRangeV2.lower);
        }
        if (maybeTildeRangeV1.isValid()) {
            if (!Semver.isVersion(v2)) {
                return 1;
            }
            TildeRange tildeRangeV1 = Objects.requireNonNull(maybeTildeRangeV1.getValue());
            int compare = super.compare(currentVersion, tildeRangeV1.upperExclusive, v2);
            if (compare < 0) {
                return compare;
            }
            if (compare == 0) {
                return -1;
            }
            compare = super.compare(currentVersion, tildeRangeV1.lower, v2);
            return Math.max(compare, 0);
        }
        if (maybeTildeRangeV2.isValid()) {
            if (!Semver.isVersion(v1)) {
                return -1;
            }
            TildeRange tildeRangeV2 = Objects.requireNonNull(maybeTildeRangeV2.getValue());
            int compare = super.compare(currentVersion, v1, tildeRangeV2.upperExclusive);
            if (compare > 0) {
                return compare;
            }
            if (compare == 0) {
                return 1;
            }
            compare = super.compare(currentVersion, v1, tildeRangeV2.lower);
            return Math.min(compare, 0);
        }
        return super.compare(currentVersion, v1, v2);
    }
}

