/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;

public class Preconditions {
    public static TreeVisitor<?, ExecutionContext> check(Recipe check, TreeVisitor<?, ExecutionContext> v) {
        if (check instanceof ScanningRecipe) {
            throw new IllegalArgumentException("ScanningRecipe is not supported as a check");
        }
        return new RecipeCheck(check, v);
    }

    public static TreeVisitor<?, ExecutionContext> check(@Nullable TreeVisitor<?, ExecutionContext> check, TreeVisitor<?, ExecutionContext> v) {
        return check == null ? v : new Check(check, v);
    }

    public static TreeVisitor<?, ExecutionContext> check(boolean check, TreeVisitor<?, ExecutionContext> v) {
        return check ? v : TreeVisitor.noop();
    }

    public static TreeVisitor<?, ExecutionContext> not(final TreeVisitor<?, ExecutionContext> v) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile;
                SourceFile sourceFile2 = sourceFile = tree instanceof SourceFile ? (SourceFile)tree : null;
                if (sourceFile != null && !v.isAcceptable(sourceFile, ctx)) {
                    return SearchResult.found(tree);
                }
                Object t2 = v.visit(tree, DataTableSuppressingExecutionContextView.view(ctx));
                return tree == t2 && tree != null ? SearchResult.found(tree) : tree;
            }
        };
    }

    @SafeVarargs
    public static TreeVisitor<?, ExecutionContext> or(final TreeVisitor<?, ExecutionContext> ... vs) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = tree instanceof SourceFile ? (SourceFile)tree : null;
                DataTableSuppressingExecutionContextView suppressingCtx = DataTableSuppressingExecutionContextView.view(ctx);
                for (TreeVisitor v : vs) {
                    Object t2;
                    if (sourceFile != null && !v.isAcceptable(sourceFile, ctx) || tree == (t2 = v.visit(tree, suppressingCtx))) continue;
                    return t2;
                }
                return tree;
            }
        };
    }

    @SafeVarargs
    public static TreeVisitor<?, ExecutionContext> and(final TreeVisitor<?, ExecutionContext> ... vs) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = tree instanceof SourceFile ? (SourceFile)tree : null;
                DataTableSuppressingExecutionContextView suppressingCtx = DataTableSuppressingExecutionContextView.view(ctx);
                Tree t2 = tree;
                for (TreeVisitor v : vs) {
                    if (sourceFile != null && !v.isAcceptable(sourceFile, ctx) || tree != (t2 = v.visit(tree, suppressingCtx))) continue;
                    return tree;
                }
                return t2;
            }
        };
    }

    @SafeVarargs
    public static Supplier<TreeVisitor<?, ExecutionContext>> and(Supplier<TreeVisitor<?, ExecutionContext>> ... svs) {
        return () -> {
            TreeVisitor[] visitors = new TreeVisitor[svs.length];
            for (int i = 0; i < svs.length; ++i) {
                Supplier sv = svs[i];
                visitors[i] = (TreeVisitor)sv.get();
            }
            return Preconditions.and(visitors);
        };
    }

    public static class RecipeCheck
    extends Check {
        private final Recipe check;

        public RecipeCheck(Recipe check, TreeVisitor<?, ExecutionContext> v) {
            super(check.getVisitor(), v);
            this.check = check;
        }

        public Recipe getRecipe() {
            return this.check;
        }
    }

    public static class Check
    extends TreeVisitor<Tree, ExecutionContext> {
        private final TreeVisitor<?, ExecutionContext> check;
        private final TreeVisitor<?, ExecutionContext> v;

        public Check(TreeVisitor<?, ExecutionContext> check, TreeVisitor<?, ExecutionContext> v) {
            this.check = check;
            this.v = v;
        }

        @Override
        public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
            return this.check.isAcceptable(sourceFile, ctx) && this.v.isAcceptable(sourceFile, ctx);
        }

        @Override
        public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            return !(tree instanceof SourceFile) || this.check.visit(tree, (ExecutionContext)DataTableSuppressingExecutionContextView.view(ctx)) != tree ? this.v.visit(tree, ctx) : tree;
        }

        @Override
        public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx, Cursor parent) {
            return !(tree instanceof SourceFile) || this.check.visit(tree, DataTableSuppressingExecutionContextView.view(ctx), parent) != tree ? this.v.visit(tree, ctx, parent) : tree;
        }

        @Generated
        public TreeVisitor<?, ExecutionContext> getCheck() {
            return this.check;
        }
    }

    private static class DataTableSuppressingExecutionContextView
    extends DelegatingExecutionContext {
        private DataTableSuppressingExecutionContextView(ExecutionContext delegate) {
            super(delegate);
        }

        public static DataTableSuppressingExecutionContextView view(ExecutionContext ctx) {
            if (ctx instanceof DataTableSuppressingExecutionContextView) {
                return (DataTableSuppressingExecutionContextView)ctx;
            }
            return new DataTableSuppressingExecutionContextView(ctx);
        }

        @Override
        public void putMessage(String key, @Nullable Object value) {
            if (!"org.openrewrite.dataTables".equals(key)) {
                super.putMessage(key, value);
            }
        }

        @Override
        public <V, T> T computeMessage(String key, @Nullable V value, Supplier<T> defaultValue, BiFunction<@Nullable V, ? super T, ? extends T> remappingFunction) {
            if ("org.openrewrite.dataTables".equals(key)) {
                return defaultValue.get();
            }
            return super.computeMessage(key, value, defaultValue, remappingFunction);
        }
    }
}

