/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeBundleResolver;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeListing
implements Comparable<RecipeListing> {
    private final @Nullable RecipeMarketplace marketplace;
    private final String name;
    private final @NlsRewrite.DisplayName String displayName;
    private final @NlsRewrite.Description String description;
    private final @Nullable Duration estimatedEffortPerOccurrence;
    private final List<? extends Option> options;
    private final RecipeBundle bundle;

    public RecipeBundleReader resolve() {
        if (this.marketplace != null) {
            for (RecipeBundleResolver resolver : this.marketplace.getResolvers()) {
                if (!resolver.getEcosystem().equals(this.bundle.getPackageEcosystem())) continue;
                return resolver.resolve(this.bundle);
            }
        }
        throw new IllegalStateException("This listing has not been configured with a resolver.");
    }

    public RecipeDescriptor describe() {
        return this.resolve().describe(this);
    }

    public Recipe prepare(Map<String, Object> options) {
        return this.resolve().prepare(this, options);
    }

    @Override
    public int compareTo(RecipeListing o) {
        return this.name.compareTo(o.name);
    }

    public static RecipeListing fromDescriptor(RecipeDescriptor descriptor, RecipeBundle bundle) {
        return new RecipeListing(null, descriptor.getName(), descriptor.getDisplayName(), descriptor.getDescription(), descriptor.getEstimatedEffortPerOccurrence(), descriptor.getOptions().stream().map(opt -> new Option(opt.getName(), opt.getDisplayName(), opt.getDescription())).collect(Collectors.toList()), bundle);
    }

    @Generated
    public @Nullable RecipeMarketplace getMarketplace() {
        return this.marketplace;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public List<? extends Option> getOptions() {
        return this.options;
    }

    @Generated
    public RecipeBundle getBundle() {
        return this.bundle;
    }

    @Generated
    public RecipeListing(@Nullable RecipeMarketplace marketplace, String name, String displayName, String description, @Nullable Duration estimatedEffortPerOccurrence, List<? extends Option> options, RecipeBundle bundle) {
        this.marketplace = marketplace;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.options = options;
        this.bundle = bundle;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeListing)) {
            return false;
        }
        RecipeListing other = (RecipeListing)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RecipeListing;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @NonNull
    @Generated
    RecipeListing withMarketplace(@Nullable RecipeMarketplace marketplace) {
        return this.marketplace == marketplace ? this : new RecipeListing(marketplace, this.name, this.displayName, this.description, this.estimatedEffortPerOccurrence, this.options, this.bundle);
    }

    @NonNull
    @Generated
    RecipeListing withBundle(RecipeBundle bundle) {
        return this.bundle == bundle ? this : new RecipeListing(this.marketplace, this.name, this.displayName, this.description, this.estimatedEffortPerOccurrence, this.options, bundle);
    }

    public static class Option {
        String name;
        @NlsRewrite.DisplayName String displayName;
        @NlsRewrite.Description String description;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Option)) {
                return false;
            }
            Option other = (Option)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Option;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RecipeListing.Option(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public Option() {
        }

        @Generated
        public Option(String name, String displayName, String description) {
            this.name = name;
            this.displayName = displayName;
            this.description = description;
        }
    }
}

