/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.table.TextMatches;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class Find
extends Recipe {
    private final transient TextMatches textMatches = new TextMatches(this);
    @Option(displayName="Find", description="The text to find. This snippet can be multiline.", example="blacklist")
    private final String find;
    @Option(displayName="Regex", description="If true, `find` will be interpreted as a [Regular Expression](https://en.wikipedia.org/wiki/Regular_expression). Default `false`.", required=false)
    private final @Nullable Boolean regex;
    @Option(displayName="Case sensitive", description="If `true` the search will be sensitive to case. Default `false`.", required=false)
    private final @Nullable Boolean caseSensitive;
    @Option(displayName="Regex multiline mode", description="When performing a regex search setting this to `true` allows \"^\" and \"$\" to match the beginning and end of lines, respectively. When performing a regex search when this is `false` \"^\" and \"$\" will match only the beginning and ending of the entire source file, respectively.Has no effect when not performing a regex search. Default `false`.", required=false)
    private final @Nullable Boolean multiline;
    @Option(displayName="Regex dot all", description="When performing a regex search setting this to `true` allows \".\" to match line terminators.Has no effect when not performing a regex search. Default `false`.", required=false)
    private final @Nullable Boolean dotAll;
    @Option(displayName="File pattern", description="A glob expression that can be used to constrain which directories or source files should be searched. Multiple patterns may be specified, separated by a semicolon `;`. If multiple patterns are supplied any of the patterns matching will be interpreted as a match. When not set, all source files are searched.", required=false, example="**/*.java")
    private final @Nullable String filePattern;
    @Option(displayName="Description", description="Add the matched value(s) as description on the search result marker.  Default `false`.", required=false)
    private final @Nullable Boolean description;
    @Option(displayName="Context size for Datatable", description="The number of characters to include in the datatable before and after the match. Default `0`, `-1` indicates that the whole text should be used.", required=false, example="50")
    private final @Nullable Integer contextSize;

    @Override
    public String getDisplayName() {
        return "Find text";
    }

    @Override
    public String getDescription() {
        return "Textual search, optionally using Regular Expression (regex) to query.";
    }

    @Override
    public String getInstanceName() {
        return String.format("Find text `%s`", this.find);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor<Tree, ExecutionContext> visitor = new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                String searchStr = Find.this.find;
                if (!Boolean.TRUE.equals(Find.this.regex)) {
                    searchStr = Pattern.quote(searchStr);
                }
                int patternOptions = 0;
                if (!Boolean.TRUE.equals(Find.this.caseSensitive)) {
                    patternOptions |= 2;
                }
                if (Boolean.TRUE.equals(Find.this.multiline)) {
                    patternOptions |= 8;
                }
                if (Boolean.TRUE.equals(Find.this.dotAll)) {
                    patternOptions |= 0x20;
                }
                Pattern pattern = Pattern.compile(searchStr, patternOptions);
                List<PlainText.Snippet> inputSnippets = ListUtils.concat(Find.snippet(plainText.getText()), plainText.getSnippets());
                ArrayList<PlainText.Snippet> newSnippets = new ArrayList<PlainText.Snippet>();
                boolean foundAnyMatch = false;
                StringBuilder fullTextContext = new StringBuilder();
                for (PlainText.Snippet snippet : inputSnippets) {
                    if (snippet.getMarkers().findFirst(SearchResult.class).isPresent()) {
                        newSnippets.add(snippet);
                        fullTextContext.append(snippet.getText());
                        continue;
                    }
                    String snippetText = snippet.getText();
                    Matcher matcher = pattern.matcher(snippetText);
                    if (!matcher.find()) {
                        newSnippets.add(snippet);
                        fullTextContext.append(snippetText);
                        continue;
                    }
                    foundAnyMatch = true;
                    String sourceFilePath = sourceFile.getSourcePath().toString();
                    int snippetOffset = fullTextContext.length();
                    String fullText = fullTextContext + snippetText;
                    AtomicInteger lastNewLineIndex = new AtomicInteger(-1);
                    AtomicInteger nextNewLineIndex = new AtomicInteger(-1);
                    AtomicBoolean isFirstMatch = new AtomicBoolean(true);
                    List<PlainText.Snippet> matchedSnippets = this.processMatches(snippetText, matcher, sourceFilePath, ctx, text -> {
                        int endLine;
                        int matchStart = matcher.start() + snippetOffset;
                        int matchEnd = matcher.end() + snippetOffset;
                        if (isFirstMatch.get()) {
                            lastNewLineIndex.set(fullText.lastIndexOf(10, matchStart));
                            nextNewLineIndex.set(fullText.indexOf(10, lastNewLineIndex.get() + 1));
                            isFirstMatch.set(false);
                        } else if (nextNewLineIndex.get() != -1 && nextNewLineIndex.get() < matchStart) {
                            while (nextNewLineIndex.get() != -1 && nextNewLineIndex.get() < matchStart) {
                                lastNewLineIndex.set(nextNewLineIndex.get());
                                nextNewLineIndex.set(fullText.indexOf(10, lastNewLineIndex.get() + 1));
                            }
                        }
                        int startLine = lastNewLineIndex.get() + 1;
                        int n = endLine = nextNewLineIndex.get() > matchEnd ? nextNewLineIndex.get() : fullText.indexOf(10, matchEnd);
                        if (endLine == -1) {
                            endLine = fullText.length();
                        }
                        return this.truncateContext(endLine, startLine, matchStart, matchEnd, fullText);
                    });
                    newSnippets.addAll(matchedSnippets);
                    fullTextContext.append(snippetText);
                }
                if (!foundAnyMatch) {
                    return sourceFile;
                }
                return plainText.withText("").withSnippets(newSnippets);
            }

            private List<PlainText.Snippet> processMatches(String text, Matcher matcher, String sourceFilePath, ExecutionContext ctx, Function<String, String> contextProvider) {
                ArrayList<PlainText.Snippet> snippets = new ArrayList<PlainText.Snippet>();
                int previousEnd = 0;
                do {
                    int matchStart;
                    if ((matchStart = matcher.start()) > previousEnd) {
                        snippets.add(Find.snippet(text.substring(previousEnd, matchStart)));
                    }
                    String matchedText = text.substring(matchStart, matcher.end());
                    snippets.add(SearchResult.found(Find.snippet(matchedText), Boolean.TRUE.equals(Find.this.description) ? matchedText : null));
                    previousEnd = matcher.end();
                    String context = contextProvider.apply(matchedText);
                    Find.this.textMatches.insertRow(ctx, new TextMatches.Row(sourceFilePath, context));
                } while (matcher.find());
                if (previousEnd < text.length()) {
                    snippets.add(Find.snippet(text.substring(previousEnd)));
                }
                return snippets;
            }

            private String truncateContext(int endLine, int startLine, int matchStart, int matchEnd, String fullText) {
                int contextLength = Find.this.contextSize == null ? 0 : Find.this.contextSize;
                int contextStart = contextLength == -1 ? startLine : matchStart - contextLength;
                int contextEnd = contextLength == -1 ? endLine : matchEnd + contextLength;
                StringBuilder sb = new StringBuilder();
                if (contextStart > startLine) {
                    sb.append("...");
                }
                sb.append(fullText, Math.max(contextStart, startLine), matchStart).append("~~>").append(fullText, matchStart, Math.min(contextEnd, endLine));
                if (contextEnd < endLine) {
                    sb.append("...");
                }
                return sb.toString();
            }
        };
        if (this.filePattern != null) {
            visitor = Preconditions.check(new FindSourceFiles(this.filePattern), visitor);
        }
        return visitor;
    }

    private static PlainText.Snippet snippet(String text) {
        return new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, text);
    }

    @Generated
    public Find(String find, @Nullable Boolean regex, @Nullable Boolean caseSensitive, @Nullable Boolean multiline, @Nullable Boolean dotAll, @Nullable String filePattern, @Nullable Boolean description, @Nullable Integer contextSize) {
        this.find = find;
        this.regex = regex;
        this.caseSensitive = caseSensitive;
        this.multiline = multiline;
        this.dotAll = dotAll;
        this.filePattern = filePattern;
        this.description = description;
        this.contextSize = contextSize;
    }

    @Generated
    public TextMatches getTextMatches() {
        return this.textMatches;
    }

    @Generated
    public String getFind() {
        return this.find;
    }

    @Generated
    public @Nullable Boolean getRegex() {
        return this.regex;
    }

    @Generated
    public @Nullable Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Generated
    public @Nullable Boolean getMultiline() {
        return this.multiline;
    }

    @Generated
    public @Nullable Boolean getDotAll() {
        return this.dotAll;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @Generated
    public @Nullable Integer getContextSize() {
        return this.contextSize;
    }

    @NonNull
    @Generated
    public String toString() {
        return "Find(textMatches=" + this.getTextMatches() + ", find=" + this.getFind() + ", regex=" + this.getRegex() + ", caseSensitive=" + this.getCaseSensitive() + ", multiline=" + this.getMultiline() + ", dotAll=" + this.getDotAll() + ", filePattern=" + this.getFilePattern() + ", description=" + this.getDescription() + ", contextSize=" + this.getContextSize() + ")";
    }

    @Override
    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Find)) {
            return false;
        }
        Find other = (Find)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Boolean this$caseSensitive = this.getCaseSensitive();
        Boolean other$caseSensitive = other.getCaseSensitive();
        if (this$caseSensitive == null ? other$caseSensitive != null : !((Object)this$caseSensitive).equals(other$caseSensitive)) {
            return false;
        }
        Boolean this$multiline = this.getMultiline();
        Boolean other$multiline = other.getMultiline();
        if (this$multiline == null ? other$multiline != null : !((Object)this$multiline).equals(other$multiline)) {
            return false;
        }
        Boolean this$dotAll = this.getDotAll();
        Boolean other$dotAll = other.getDotAll();
        if (this$dotAll == null ? other$dotAll != null : !((Object)this$dotAll).equals(other$dotAll)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Integer this$contextSize = this.getContextSize();
        Integer other$contextSize = other.getContextSize();
        if (this$contextSize == null ? other$contextSize != null : !((Object)this$contextSize).equals(other$contextSize)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        if (this$find == null ? other$find != null : !this$find.equals(other$find)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof Find;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Boolean $caseSensitive = this.getCaseSensitive();
        result = result * 59 + ($caseSensitive == null ? 43 : ((Object)$caseSensitive).hashCode());
        Boolean $multiline = this.getMultiline();
        result = result * 59 + ($multiline == null ? 43 : ((Object)$multiline).hashCode());
        Boolean $dotAll = this.getDotAll();
        result = result * 59 + ($dotAll == null ? 43 : ((Object)$dotAll).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Integer $contextSize = this.getContextSize();
        result = result * 59 + ($contextSize == null ? 43 : ((Object)$contextSize).hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

