/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;

public class HyphenRange
extends LatestRelease {
    private static final Pattern HYPHEN_RANGE_PATTERN = Pattern.compile("(\\d+(\\.\\d+)?(\\.\\d+)?(\\.\\d+)?)\\s*-\\s*(\\d+(\\.\\d+)?(\\.\\d+)?(\\.\\d+)?)");
    private final String upper;
    private final String lower;

    private HyphenRange(String lower, String upper, @Nullable String metadataPattern) {
        super(metadataPattern);
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return super.isValid(currentVersion, version) && super.compare(currentVersion, version, this.upper) <= 0 && super.compare(currentVersion, version, this.lower) >= 0;
    }

    public static Validated<HyphenRange> build(String pattern, @Nullable String metadataPattern) {
        Matcher matcher = HYPHEN_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("hyphenRange", pattern, "not a hyphen range");
        }
        return Validated.valid("hyphenRange", new HyphenRange(matcher.group(1), matcher.group(5), metadataPattern));
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        Validated<HyphenRange> maybeHyphenRangeV1 = HyphenRange.build(v1, null);
        Validated<HyphenRange> maybeHyphenRangeV2 = HyphenRange.build(v2, null);
        if (maybeHyphenRangeV1.isValid() && maybeHyphenRangeV2.isValid()) {
            HyphenRange hyphenRangeV1 = Objects.requireNonNull(maybeHyphenRangeV1.getValue());
            HyphenRange hyphenRangeV2 = Objects.requireNonNull(maybeHyphenRangeV2.getValue());
            int compare = super.compare(currentVersion, hyphenRangeV1.upper, hyphenRangeV2.upper);
            if (compare != 0) {
                return compare;
            }
            return super.compare(currentVersion, hyphenRangeV1.lower, hyphenRangeV2.lower);
        }
        if (maybeHyphenRangeV1.isValid()) {
            if (!Semver.isVersion(v2)) {
                return 1;
            }
            HyphenRange hyphenRangeV1 = Objects.requireNonNull(maybeHyphenRangeV1.getValue());
            int compare = super.compare(currentVersion, hyphenRangeV1.upper, v2);
            if (compare < 0) {
                return compare;
            }
            compare = super.compare(currentVersion, hyphenRangeV1.lower, v2);
            return Math.max(compare, 0);
        }
        if (maybeHyphenRangeV2.isValid()) {
            if (!Semver.isVersion(v1)) {
                return -1;
            }
            HyphenRange hyphenRangeV2 = Objects.requireNonNull(maybeHyphenRangeV2.getValue());
            int compare = super.compare(currentVersion, v1, hyphenRangeV2.upper);
            if (compare > 0) {
                return compare;
            }
            compare = super.compare(currentVersion, v1, hyphenRangeV2.lower);
            return Math.min(compare, 0);
        }
        return super.compare(currentVersion, v1, v2);
    }
}

