/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.objenesis.ObjenesisStd;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcObjectData;
import org.openrewrite.rpc.Trace;

public class RpcReceiveQueue {
    private static final ObjenesisStd objenesis = new ObjenesisStd();
    private final Deque<RpcObjectData> batch;
    private final Map<Integer, Object> refs;
    private final Supplier<List<RpcObjectData>> pull;
    private final @Nullable String sourceFileType;
    private final @Nullable PrintStream log;

    public RpcReceiveQueue(Map<Integer, Object> refs, Supplier<List<RpcObjectData>> pull, @Nullable String sourceFileType, @Nullable PrintStream log) {
        this.refs = refs;
        this.sourceFileType = sourceFileType;
        this.log = log;
        this.batch = new ArrayDeque<RpcObjectData>();
        this.pull = pull;
    }

    public RpcObjectData take() {
        if (this.batch.isEmpty()) {
            List<RpcObjectData> data = this.pull.get();
            this.batch.addAll(data);
        }
        return this.batch.remove();
    }

    public <T, U> T receiveAndGet(@Nullable T before, Function<U, @Nullable T> mapping) {
        T after = this.receive(before, null);
        return after != null && after != before ? mapping.apply(after) : after;
    }

    public <T> T receive(@Nullable T before) {
        return this.receive(before, null);
    }

    public <T> T receive(@Nullable T before, @Nullable UnaryOperator<T> onChange) {
        RpcObjectData message = this.take();
        Trace.traceReceiver(message, this.log);
        Integer ref = null;
        switch (message.getState()) {
            case NO_CHANGE: {
                return before;
            }
            case DELETE: {
                return null;
            }
            case ADD: {
                ref = message.getRef();
                if (ref != null && message.getValueType() == null && message.getValue() == null) {
                    if (this.refs.containsKey(ref)) {
                        return (T)this.refs.get(ref);
                    }
                    throw new IllegalStateException("Received a reference to an object that was not previously sent: " + ref);
                }
                Object object = before = message.getValueType() == null ? message.getValue() : this.newObj(message.getValueType());
                if (ref != null) {
                    this.refs.put(ref, before);
                }
            }
            case CHANGE: {
                RpcCodec<T> codec;
                Object after = onChange != null ? onChange.apply(before) : (before != null && (codec = RpcCodec.forInstance(before, this.sourceFileType)) != null ? codec.rpcReceive(before, this) : (message.getValueType() == null ? message.getValue() : before));
                if (ref != null) {
                    this.refs.put(ref, after);
                }
                return (T)after;
            }
        }
        throw new UnsupportedOperationException("Unknown state type " + (Object)((Object)message.getState()));
    }

    public <T> List<T> receiveList(@Nullable List<T> before, @Nullable UnaryOperator<T> onChange) {
        RpcObjectData msg = this.take();
        Trace.traceReceiver(msg, this.log);
        switch (msg.getState()) {
            case NO_CHANGE: {
                return before;
            }
            case DELETE: {
                return null;
            }
            case ADD: {
                before = new ArrayList<T>();
            }
            case CHANGE: {
                msg = this.take();
                assert (msg.getState() == RpcObjectData.State.CHANGE);
                List positions = Objects.requireNonNull((List)msg.getValue());
                ArrayList<Object> after = new ArrayList<Object>(positions.size());
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    int beforeIdx = (Integer)iterator.next();
                    after.add(this.receive(beforeIdx >= 0 ? (T)Objects.requireNonNull(before).get(beforeIdx) : null, onChange));
                }
                return after;
            }
        }
        throw new UnsupportedOperationException((Object)((Object)msg.getState()) + " is not supported for lists.");
    }

    private <T> T newObj(String type) {
        try {
            Class<?> clazz = Class.forName(type);
            return (T)objenesis.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Enum<T>> Function<Object, T> toEnum(Class<T> enumType) {
        return value -> Enum.valueOf(enumType, (String)value);
    }
}

