/*
 * Copyright 2020 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite;

import org.intellij.lang.annotations.Language;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Describes an option that can be set on a recipe.
 * Typically placed on a field which has getters and constructor generated by lombok.
 * Can also be placed onto constructor parameters or bean-style get<Field> methods.
 * When placed on constructor parameters only the primary constructor is considered. The primary constructor is either the only constructor or the constructor annotated with @{link com.fasterxml.jackson.annotation.JsonCreator}
 */
@Target({ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
public @interface Option {
    @Language("markdown") @NlsRewrite.DisplayName String displayName() default "";

    @Language("markdown") @NlsRewrite.Description String description() default "";

    String example() default "";

    String[] valid() default "";

    boolean required() default true;
}
