/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;

public class YamlRecipeBundle
implements RecipeBundle {
    private final URI uri;
    private final @Nullable String version;
    private final Properties properties;
    private final @Nullable String team;

    @Override
    public String getPackageEcosystem() {
        return "yaml";
    }

    @Override
    public String getPackageName() {
        return this.uri.toString();
    }

    @Override
    public RecipeDescriptor describe(RecipeListing listing) {
        return this.prepare(listing, Collections.emptyMap()).getDescriptor();
    }

    @Override
    public Recipe prepare(RecipeListing listing, Map<String, Object> options) {
        Recipe recipe;
        block8: {
            InputStream inputStream = this.uri.toURL().openStream();
            try {
                YamlResourceLoader loader = new YamlResourceLoader(inputStream, this.uri, this.properties);
                recipe = Objects.requireNonNull(loader.loadRecipe(listing.getName(), new ResourceLoader.RecipeDetail[0]));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to open stream from " + this.uri, e);
                }
            }
            inputStream.close();
        }
        return recipe;
    }

    @Generated
    public YamlRecipeBundle(URI uri, @Nullable String version, Properties properties, @Nullable String team) {
        this.uri = uri;
        this.version = version;
        this.properties = properties;
        this.team = team;
    }

    @Override
    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public @Nullable String getTeam() {
        return this.team;
    }
}

