/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.Validated;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceContentValidator {
    public Validated<RecipeMarketplace> validate(RecipeMarketplace marketplace) {
        Validated.None<RecipeMarketplace> validation = Validated.none();
        ArrayList<String> categoryPath = new ArrayList<String>();
        return this.validateRecursive(marketplace, validation, categoryPath);
    }

    private Validated<RecipeMarketplace> validateRecursive(RecipeMarketplace marketplace, Validated<RecipeMarketplace> validation, List<String> categoryPath) {
        if (!marketplace.isRoot()) {
            validation = validation.and(this.validateDisplayName(marketplace.getDisplayName(), "category: " + marketplace.getDisplayName()));
            if (!marketplace.getDescription().isEmpty()) {
                validation = validation.and(this.validateDescription(marketplace.getDescription(), "category: " + marketplace.getDisplayName()));
            }
        }
        for (RecipeListing recipe : marketplace.getRecipes()) {
            String categoryContext = categoryPath.isEmpty() ? "root" : String.join((CharSequence)" > ", categoryPath);
            validation = validation.and(this.validateDisplayName(recipe.getDisplayName(), "displayName in " + categoryContext));
            validation = validation.and(this.validateDescription(recipe.getDescription(), "description in " + categoryContext));
        }
        ArrayList<String> newPath = new ArrayList<String>(categoryPath);
        if (!marketplace.isRoot()) {
            newPath.add(marketplace.getDisplayName());
        }
        for (RecipeMarketplace category : marketplace.getCategories()) {
            validation = this.validateRecursive(category, validation, newPath);
        }
        return validation;
    }

    private Validated<RecipeMarketplace> validateDisplayName(String displayName, String context) {
        if (displayName.isEmpty()) {
            return Validated.invalid("displayName", displayName, "Display name is empty [" + context + "]");
        }
        Validated<RecipeMarketplace> validation = Validated.none();
        if (!Character.isUpperCase(displayName.charAt(0))) {
            validation = validation.and(Validated.invalid("displayName", displayName, "Display name must start with an uppercase letter: '" + displayName + "' [" + context + "]"));
        }
        if (displayName.endsWith(".")) {
            validation = validation.and(Validated.invalid("displayName", displayName, "Display name must not end with a period: '" + displayName + "' [" + context + "]"));
        }
        return validation;
    }

    private Validated<RecipeMarketplace> validateDescription(String description, String context) {
        if (description.isEmpty()) {
            return Validated.none();
        }
        Validated<RecipeMarketplace> validation = Validated.none();
        if (!description.endsWith(".")) {
            validation = validation.and(Validated.invalid("description", description, "Description must end with a period: '" + description + "' [" + context + "]"));
        }
        return validation;
    }
}

