/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.util.HashSet;
import org.openrewrite.Validated;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceCompletenessValidator {
    public Validated<RecipeMarketplace> validate(RecipeMarketplace csv, Environment jar) {
        Validated<RecipeMarketplace> validation = Validated.none();
        HashSet<String> csvRecipeNames = new HashSet<String>();
        for (RecipeListing recipe : csv.getAllRecipes()) {
            csvRecipeNames.add(recipe.getName());
        }
        HashSet<String> jarRecipeNames = new HashSet<String>();
        for (RecipeDescriptor descriptor : jar.listRecipeDescriptors()) {
            jarRecipeNames.add(descriptor.getName());
        }
        for (String csvRecipeName : csvRecipeNames) {
            if (jarRecipeNames.contains(csvRecipeName)) continue;
            validation = validation.and(Validated.invalid("recipe", csvRecipeName, "Recipe listed in CSV does not exist in JAR: '" + csvRecipeName + "' [phantom recipe]"));
        }
        for (String jarRecipeName : jarRecipeNames) {
            if (csvRecipeNames.contains(jarRecipeName)) continue;
            validation = validation.and(Validated.invalid("recipe", jarRecipeName, "Recipe exists in JAR but is not listed in CSV: '" + jarRecipeName + "' [missing from CSV]"));
        }
        return validation;
    }
}

