/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleLoader;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.marketplace.RecipeOffering;

public class RecipeMarketplaceReader {
    private final Map<String, RecipeBundleLoader> bundleLoaders = new HashMap<String, RecipeBundleLoader>();

    public RecipeMarketplaceReader(RecipeBundleLoader ... bundleLoaders) {
        for (RecipeBundleLoader loader : bundleLoaders) {
            this.bundleLoaders.put(loader.getEcosystem().toLowerCase(), loader);
        }
    }

    public RecipeMarketplace fromCsv(@Language(value="csv") String csv) {
        return this.fromCsv(new StringReader(csv));
    }

    public RecipeMarketplace fromCsv(Path csv) {
        try {
            return this.fromCsv(Files.newBufferedReader(csv));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read from CSV", e);
        }
    }

    public RecipeMarketplace fromCsv(InputStream csv) {
        return this.fromCsv(new InputStreamReader(csv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeMarketplace fromCsv(Reader csv) {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setLineSeparatorDetectionEnabled(true);
        settings.setHeaderExtractionEnabled(false);
        settings.setNullValue("");
        settings.setDelimiterDetectionEnabled(true, new char[]{',', '\t', ';'});
        CsvParser parser = new CsvParser(settings);
        parser.beginParsing(csv);
        try {
            String[] row;
            RecipeMarketplace root = RecipeMarketplace.newEmpty();
            List<NamedColumn> headers = null;
            int line = 0;
            while ((row = parser.parseNext()) != null) {
                ++line;
                if (row.length == 0 || row.length == 1 && row[0] == null) continue;
                if (headers == null) {
                    headers = this.parseHeaders(row);
                    continue;
                }
                this.readRecipeOffering(row, root, headers);
            }
            if (root.getCategories().size() == 1 && root.getRecipes().isEmpty()) {
                RecipeMarketplace recipeMarketplace = root.getCategories().get(0);
                return recipeMarketplace;
            }
            RecipeMarketplace recipeMarketplace = root;
            return recipeMarketplace;
        }
        finally {
            parser.stopParsing();
        }
    }

    private List<NamedColumn> parseHeaders(@Nullable String[] row) {
        ArrayList<NamedColumn> headers = new ArrayList<NamedColumn>();
        for (String headerName : row) {
            if (headerName == null) continue;
            headerName = headerName.trim();
            headers.add(Column.fromString(headerName));
        }
        return headers;
    }

    private void readRecipeOffering(@Nullable String[] row, RecipeMarketplace root, List<NamedColumn> headers) {
        RecipeBundleLoader loader;
        String name = null;
        String displayName = null;
        String description = null;
        String ecosystem = null;
        String packageName = null;
        String version = null;
        String team = null;
        ArrayList<String> categories = new ArrayList<String>();
        TreeMap<Integer, OptionData> options = new TreeMap<Integer, OptionData>();
        block13: for (int i = 0; i < row.length && i < headers.size(); ++i) {
            String value = row[i];
            if (value != null && StringUtils.isBlank(value = value.trim())) {
                value = null;
            }
            NamedColumn column = headers.get(i);
            switch (column.getColumn().ordinal()) {
                case 0: {
                    name = value;
                    continue block13;
                }
                case 1: {
                    displayName = value;
                    continue block13;
                }
                case 2: {
                    description = value;
                    continue block13;
                }
                case 3: {
                    if (value == null) continue block13;
                    categories.add(value);
                    continue block13;
                }
                case 4: {
                    ecosystem = value;
                    continue block13;
                }
                case 5: {
                    packageName = value;
                    continue block13;
                }
                case 6: {
                    version = value;
                    continue block13;
                }
                case 7: {
                    team = value;
                    continue block13;
                }
                case 8: {
                    if (value == null) continue block13;
                    int optionIndex = column.getIndex();
                    options.computeIfAbsent(optionIndex, k -> new OptionData()).setName(value);
                    continue block13;
                }
                case 9: {
                    if (value == null) continue block13;
                    int optionIndex = column.getIndex();
                    options.computeIfAbsent(optionIndex, k -> new OptionData()).setDisplayName(value);
                    continue block13;
                }
                case 10: {
                    if (value == null) continue block13;
                    int optionIndex = column.getIndex();
                    options.computeIfAbsent(optionIndex, k -> new OptionData()).setDescription(value);
                    continue block13;
                }
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("CSV file must contain a column named 'name' and each row must have a value for it");
        }
        RecipeBundle bundle = null;
        if (ecosystem != null && packageName != null && version != null && (loader = this.bundleLoaders.get(ecosystem.toLowerCase())) != null) {
            bundle = loader.createBundle(packageName, version, team);
        }
        ArrayList<RecipeOffering.Option> offeringOptions = new ArrayList<RecipeOffering.Option>();
        for (OptionData optionData : options.values()) {
            if (optionData.getName() == null) continue;
            offeringOptions.add(new RecipeOffering.Option(optionData.getName(), optionData.getDisplayName() != null ? optionData.getDisplayName() : optionData.getName(), optionData.getDescription() != null ? optionData.getDescription() : ""));
        }
        RecipeOffering offering = new RecipeOffering(name, displayName != null ? displayName : name, name, description != null ? description : "", Collections.emptySet(), null, offeringOptions, bundle);
        RecipeMarketplace targetCategory = this.navigateToCategory(root, categories);
        targetCategory.getRecipes().add(offering);
    }

    private RecipeMarketplace navigateToCategory(RecipeMarketplace root, List<String> categories) {
        if (categories.isEmpty()) {
            return root;
        }
        RecipeMarketplace current = root;
        for (int i = categories.size() - 1; i >= 0; --i) {
            String categoryName = categories.get(i);
            RecipeMarketplace found = null;
            for (RecipeMarketplace child : current.getCategories()) {
                if (!child.getDisplayName().equals(categoryName)) continue;
                found = child;
                break;
            }
            if (found == null) {
                found = new RecipeMarketplace(categoryName, categoryName);
                current.getCategories().add(found);
            }
            current = found;
        }
        return current;
    }

    private static enum Column {
        NAME("name"),
        DISPLAY_NAME("displayName"),
        DESCRIPTION("description"),
        CATEGORY("category"),
        ECOSYSTEM("ecosystem"),
        PACKAGE_NAME("packageName"),
        VERSION("version"),
        TEAM("team"),
        OPTION_NAME("optionName"),
        OPTION_DISPLAY_NAME("optionDisplayName"),
        OPTION_DESCRIPTION("optionDescription"),
        UNKNOWN("_unknown");

        private final String columnName;
        private static final Pattern OPTION_NAME_PATTERN;
        private static final Pattern OPTION_DISPLAY_NAME_PATTERN;
        private static final Pattern OPTION_DESCRIPTION_PATTERN;

        public static NamedColumn fromString(String key) {
            String lowerKey = key.toLowerCase();
            if (lowerKey.startsWith("category")) {
                return new NamedColumn(CATEGORY, key, -1);
            }
            Matcher optionNameMatcher = OPTION_NAME_PATTERN.matcher(key);
            if (optionNameMatcher.matches()) {
                int index = Integer.parseInt(optionNameMatcher.group(1));
                return new NamedColumn(OPTION_NAME, key, index);
            }
            Matcher optionDisplayNameMatcher = OPTION_DISPLAY_NAME_PATTERN.matcher(key);
            if (optionDisplayNameMatcher.matches()) {
                int index = Integer.parseInt(optionDisplayNameMatcher.group(1));
                return new NamedColumn(OPTION_DISPLAY_NAME, key, index);
            }
            Matcher optionDescriptionMatcher = OPTION_DESCRIPTION_PATTERN.matcher(key);
            if (optionDescriptionMatcher.matches()) {
                int index = Integer.parseInt(optionDescriptionMatcher.group(1));
                return new NamedColumn(OPTION_DESCRIPTION, key, index);
            }
            for (Column column : Column.values()) {
                if (!column.columnName.equalsIgnoreCase(key)) continue;
                return new NamedColumn(column, key, -1);
            }
            return new NamedColumn(UNKNOWN, key, -1);
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        private Column(String columnName) {
            this.columnName = columnName;
        }

        static {
            OPTION_NAME_PATTERN = Pattern.compile("option(\\d+)Name", 2);
            OPTION_DISPLAY_NAME_PATTERN = Pattern.compile("option(\\d+)DisplayName", 2);
            OPTION_DESCRIPTION_PATTERN = Pattern.compile("option(\\d+)Description", 2);
        }
    }

    private static final class NamedColumn {
        private final Column column;
        private final String headerName;
        private final int index;

        @Generated
        public NamedColumn(Column column, String headerName, int index) {
            this.column = column;
            this.headerName = headerName;
            this.index = index;
        }

        @Generated
        public Column getColumn() {
            return this.column;
        }

        @Generated
        public String getHeaderName() {
            return this.headerName;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedColumn)) {
                return false;
            }
            NamedColumn other = (NamedColumn)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            Column this$column = this.getColumn();
            Column other$column = other.getColumn();
            if (this$column == null ? other$column != null : !((Object)((Object)this$column)).equals((Object)other$column)) {
                return false;
            }
            String this$headerName = this.getHeaderName();
            String other$headerName = other.getHeaderName();
            return !(this$headerName == null ? other$headerName != null : !this$headerName.equals(other$headerName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            Column $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : ((Object)((Object)$column)).hashCode());
            String $headerName = this.getHeaderName();
            result = result * 59 + ($headerName == null ? 43 : $headerName.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RecipeMarketplaceReader.NamedColumn(column=" + (Object)((Object)this.getColumn()) + ", headerName=" + this.getHeaderName() + ", index=" + this.getIndex() + ")";
        }
    }

    private static class OptionData {
        private @Nullable String name;
        private @Nullable String displayName;
        private @Nullable String description;

        @Generated
        public OptionData() {
        }

        @Generated
        public @Nullable String getName() {
            return this.name;
        }

        @Generated
        public @Nullable String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public @Nullable String getDescription() {
            return this.description;
        }

        @Generated
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @Generated
        public void setDisplayName(@Nullable String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OptionData)) {
                return false;
            }
            OptionData other = (OptionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof OptionData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RecipeMarketplaceReader.OptionData(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
        }
    }
}

