/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class XRange
extends LatestRelease {
    private static final Pattern X_RANGE_PATTERN = Pattern.compile("([*xX]|\\d+)(?:\\.([*xX]|\\d+)(?:\\.([*xX]|\\d+))?(?:\\.([*xX]|\\d+))?)?");
    private final String major;
    private final String minor;
    private final String patch;
    private final String micro;

    XRange(String major, String minor, String patch, String micro, @Nullable String metadataPattern) {
        super(metadataPattern);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.micro = micro;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        if (!super.isValid(currentVersion, version)) {
            return false;
        }
        if ("*".equals(this.major)) {
            return true;
        }
        Matcher gav = VersionComparator.RELEASE_PATTERN.matcher(XRange.normalizeVersion(version));
        gav.matches();
        if (!gav.group(1).equals(this.major)) {
            return false;
        }
        if ("*".equals(this.minor)) {
            return true;
        }
        if (gav.group(2) == null || !gav.group(2).equals(this.minor)) {
            return false;
        }
        if ("*".equals(this.patch)) {
            return true;
        }
        if (gav.group(3) == null || !gav.group(3).equals(this.patch)) {
            return false;
        }
        return gav.group(4) == null || !gav.group(4).equals(this.micro);
    }

    public static Validated<XRange> build(String pattern, @Nullable String metadataPattern) {
        Matcher matcher = X_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches() || !pattern.contains("x") && !pattern.contains("X") && !pattern.contains("*")) {
            return Validated.invalid("xRange", pattern, "not an x-range");
        }
        String major = XRange.normalizeWildcard(matcher.group(1));
        String minor = XRange.normalizeWildcard(matcher.group(2) == null ? "0" : matcher.group(2));
        String patch = XRange.normalizeWildcard(matcher.group(3) == null ? "0" : matcher.group(3));
        String micro = XRange.normalizeWildcard(matcher.group(4) == null ? "0" : matcher.group(4));
        if ("*".equals(major) && (matcher.group(2) != null || matcher.group(3) != null || matcher.group(4) != null)) {
            return Validated.invalid("xRange", pattern, "not an x-range: nothing can follow a wildcard");
        }
        if ("*".equals(minor) && (matcher.group(3) != null || matcher.group(4) != null)) {
            return Validated.invalid("xRange", pattern, "not an x-range: nothing can follow a wildcard");
        }
        if ("*".equals(patch) && matcher.group(4) != null) {
            return Validated.invalid("xRange", pattern, "not an x-range: nothing can follow a wildcard");
        }
        return Validated.valid("xRange", new XRange(major, minor, patch, micro, metadataPattern));
    }

    private static String normalizeWildcard(String part) {
        return "*".equals(part) || "x".equals(part) || "X".equals(part) ? "*" : part;
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        Validated<XRange> maybeXRangeV1 = XRange.build(v1, null);
        Validated<XRange> maybeXRangeV2 = XRange.build(v2, null);
        if (maybeXRangeV1.isValid() && maybeXRangeV2.isValid()) {
            XRange xrangeV1 = Objects.requireNonNull(maybeXRangeV1.getValue());
            XRange xrangeV2 = Objects.requireNonNull(maybeXRangeV2.getValue());
            if ("*".equals(xrangeV1.major) && "*".equals(xrangeV2.major)) {
                return 0;
            }
            if ("*".equals(xrangeV1.major)) {
                return 1;
            }
            if ("*".equals(xrangeV2.major)) {
                return -1;
            }
            int compare = xrangeV1.major.compareTo(xrangeV2.major);
            if (compare != 0) {
                return compare;
            }
            if ("*".equals(xrangeV1.minor) && "*".equals(xrangeV2.minor)) {
                return 0;
            }
            if ("*".equals(xrangeV1.minor)) {
                return 1;
            }
            if ("*".equals(xrangeV2.minor)) {
                return -1;
            }
            compare = xrangeV1.minor.compareTo(xrangeV2.minor);
            if (compare != 0) {
                return compare;
            }
            if ("*".equals(xrangeV1.patch) && "*".equals(xrangeV2.patch)) {
                return 0;
            }
            if ("*".equals(xrangeV1.patch)) {
                return 1;
            }
            if ("*".equals(xrangeV2.patch)) {
                return -1;
            }
            return xrangeV1.patch.compareTo(xrangeV2.patch);
        }
        if (maybeXRangeV1.isValid()) {
            if (!Semver.isVersion(v2)) {
                return 1;
            }
            XRange xrangeV1 = Objects.requireNonNull(maybeXRangeV1.getValue());
            if ("*".equals(xrangeV1.major)) {
                return 0;
            }
            Matcher gav = VersionComparator.RELEASE_PATTERN.matcher(XRange.normalizeVersion(v2));
            gav.matches();
            if (!xrangeV1.major.equals(gav.group(1))) {
                return xrangeV1.major.compareTo(gav.group(1));
            }
            if ("*".equals(xrangeV1.minor)) {
                return 0;
            }
            if (gav.group(2) == null || !xrangeV1.minor.equals(gav.group(2))) {
                return xrangeV1.minor.compareTo(gav.group(2));
            }
            if ("*".equals(xrangeV1.patch)) {
                return 0;
            }
            if (gav.group(3) == null || !xrangeV1.patch.equals(gav.group(3))) {
                return xrangeV1.patch.compareTo(gav.group(3));
            }
            return 0;
        }
        if (maybeXRangeV2.isValid()) {
            if (!Semver.isVersion(v1)) {
                return -1;
            }
            XRange xrangeV2 = Objects.requireNonNull(maybeXRangeV2.getValue());
            if ("*".equals(xrangeV2.major)) {
                return 0;
            }
            Matcher gav = VersionComparator.RELEASE_PATTERN.matcher(XRange.normalizeVersion(v1));
            gav.matches();
            if (!gav.group(1).equals(xrangeV2.major)) {
                return gav.group(1).compareTo(xrangeV2.major);
            }
            if ("*".equals(xrangeV2.minor)) {
                return 0;
            }
            if (gav.group(2) == null || !gav.group(2).equals(xrangeV2.minor)) {
                return gav.group(2).compareTo(xrangeV2.minor);
            }
            if ("*".equals(xrangeV2.patch)) {
                return 0;
            }
            if (gav.group(3) == null || !gav.group(3).equals(xrangeV2.patch)) {
                return gav.group(3).compareTo(xrangeV2.patch);
            }
            return 0;
        }
        return super.compare(currentVersion, v1, v2);
    }
}

