/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.rpc.RpcObjectData;

public class Trace {
    private static final StackElementSourceLookup sourceLookup = new StackElementSourceLookup();
    public static boolean TRACE_SENDER = false;
    public static @Nullable PrintStream TRACE_RECEIVER = null;

    public static void traceReceiver(RpcObjectData message) {
        PrintStream logFile = TRACE_RECEIVER;
        if (logFile != null && message.getTrace() != null) {
            logFile.println(message.withTrace(null));
            logFile.println("  " + message.getTrace());
            logFile.println("  " + Trace.trace("Receiver"));
            logFile.flush();
        }
    }

    public static @Nullable String traceSender() {
        return TRACE_SENDER ? Trace.trace("Sender") : null;
    }

    private static String trace(String type) {
        for (StackTraceElement stackElement : Thread.currentThread().getStackTrace()) {
            if (!stackElement.getClassName().endsWith(type)) continue;
            return stackElement.getClassName().substring(stackElement.getClassName().lastIndexOf(46) + 1) + ":" + stackElement.getLineNumber() + " => " + sourceLookup.getSource(stackElement).trim();
        }
        return "Unknown";
    }

    public static class StackElementSourceLookup {
        private final Map<String, Path> sourceByClassName = new HashMap<String, Path>();
        private Path repositoryRoot = Paths.get(".", new String[0]).toAbsolutePath();

        public StackElementSourceLookup() {
            while (!this.repositoryRoot.resolve(".git").toFile().exists()) {
                this.repositoryRoot = this.repositoryRoot.getParent();
            }
        }

        public String getSource(StackTraceElement element) {
            String className = element.getClassName();
            Path sourcePath = this.sourceByClassName.computeIfAbsent(className, k -> this.lookupSourcePath(className));
            if (sourcePath == null) {
                return "Source code unavailable";
            }
            try {
                List<String> lines = Files.readAllLines(sourcePath, StandardCharsets.UTF_8);
                int lineNum = element.getLineNumber();
                if (lineNum <= lines.size()) {
                    return lines.get(lineNum - 1);
                }
                return "Line number " + lineNum + " is out of bounds for " + sourcePath;
            }
            catch (IOException ignored) {
                return "Source code unavailable";
            }
        }

        private @Nullable Path lookupSourcePath(String className) {
            Path path;
            block8: {
                String relativePath = className.replace('.', File.separatorChar) + ".java";
                Stream<Path> paths = Files.walk(this.repositoryRoot, new FileVisitOption[0]);
                try {
                    path = paths.filter(p -> p.toString().endsWith(relativePath)).findFirst().orElse(null);
                    if (paths == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (paths != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        return null;
                    }
                }
                paths.close();
            }
            return path;
        }
    }
}

