/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.Generated;
import org.openrewrite.Recipe;

public class RecipeSerializer {
    private final ObjectMapper mapper;

    public RecipeSerializer() {
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        ObjectMapper m = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)f).constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).build()).registerModules(new Module[]{new ParameterNamesModule(), new JavaTimeModule()}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        RecipeSerializer.maybeAddKotlinModule(m);
        this.mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public void write(Recipe recipe, OutputStream out) {
        try {
            this.mapper.writeValue(out, (Object)recipe);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] write(Recipe recipe) {
        try {
            return this.mapper.writeValueAsBytes((Object)recipe);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public Recipe read(InputStream input) {
        try {
            return (Recipe)this.mapper.readValue(input, Recipe.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Recipe read(byte[] bytes) {
        try {
            return (Recipe)this.mapper.readValue(bytes, Recipe.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void maybeAddKotlinModule(ObjectMapper mapper) {
        try {
            Class<?> kmbClass = RecipeSerializer.class.getClassLoader().loadClass("com.fasterxml.jackson.module.kotlin.KotlinModule$Builder");
            Constructor<?> kmbConstructor = kmbClass.getConstructor(new Class[0]);
            Object kotlinModuleBuilder = kmbConstructor.newInstance(new Object[0]);
            Method kmbBuildMethod = kmbClass.getMethod("build", new Class[0]);
            Module kotlinModule = (Module)kmbBuildMethod.invoke(kotlinModuleBuilder, new Object[0]);
            mapper.registerModule(kotlinModule);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

