/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceFileWithReferences;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcSendQueue;
import org.openrewrite.text.PlainTextPrinter;
import org.openrewrite.text.PlainTextVisitor;

public final class PlainText
implements SourceFileWithReferences,
Tree,
RpcCodec<PlainText> {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    private final @Nullable String charsetName;
    private final boolean charsetBomMarked;
    private final @Nullable FileAttributes fileAttributes;
    private final @Nullable Checksum checksum;
    private final String text;
    private final @Nullable List<Snippet> snippets;
    private transient @Nullable SoftReference<SourceFileWithReferences.References> references;

    @Override
    public Charset getCharset() {
        return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
    }

    public SourceFile withCharset(Charset charset) {
        return this.withCharsetName(charset.name());
    }

    public PlainText(UUID id, Path sourcePath, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Nullable Checksum checksum, String text, @Nullable List<Snippet> snippets) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.charsetName = charsetName;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
        this.checksum = checksum;
        this.text = text;
        this.snippets = snippets;
    }

    @Override
    public SourceFileWithReferences.References getReferences() {
        this.references = this.build(this.references);
        return Objects.requireNonNull(this.references.get());
    }

    public PlainText withText(String text) {
        if (!text.equals(this.text)) {
            return new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, text, this.snippets, this.references);
        }
        return this;
    }

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(PlainTextVisitor.class);
    }

    @Override
    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)v.adapt(PlainTextVisitor.class).visitText(this, p);
    }

    @Override
    public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return new PlainTextPrinter();
    }

    @Override
    public long getWeight(Predicate<Object> uniqueIdentity) {
        return this.text.length() / 10;
    }

    public List<Snippet> getSnippets() {
        if (this.snippets == null) {
            return Collections.emptyList();
        }
        return this.snippets;
    }

    public PlainText withSnippets(@Nullable List<Snippet> snippets) {
        if (this.snippets == (snippets = ListUtils.nullIfEmpty(snippets))) {
            return this;
        }
        return new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text, snippets, null);
    }

    @Override
    public void rpcSend(PlainText after, RpcSendQueue q) {
        q.getAndSend(after, Tree::getId);
        q.getAndSend(after, Tree::getMarkers);
        q.getAndSend(after, d -> d.getSourcePath().toString());
        q.getAndSend(after, d -> d.getCharset().name());
        q.getAndSend(after, PlainText::isCharsetBomMarked);
        q.getAndSend(after, PlainText::getChecksum);
        q.getAndSend(after, PlainText::getFileAttributes);
        q.getAndSend(after, PlainText::getText);
        q.getAndSendList(after, PlainText::getSnippets, Tree::getId, snippet -> {
            q.getAndSend(snippet, Tree::getId);
            q.getAndSend(snippet, Tree::getMarkers);
            q.getAndSend(snippet, Snippet::getText);
        });
    }

    @Override
    public PlainText rpcReceive(PlainText t, RpcReceiveQueue q) {
        return t.withId(q.receiveAndGet(t.getId(), UUID::fromString)).withMarkers(q.receive(t.getMarkers())).withSourcePath(q.receiveAndGet(t.getSourcePath(), x$0 -> Paths.get(x$0, new String[0]))).withCharsetName(q.receiveAndGet(t.getCharsetName(), String::toString)).withCharsetBomMarked(q.receive(t.isCharsetBomMarked())).withChecksum(q.receive(t.getChecksum())).withFileAttributes(q.receive(t.getFileAttributes())).withText(q.receive(t.getText())).withSnippets(q.receiveList(t.getSnippets(), s -> s.withId(q.receiveAndGet(s.getId(), UUID::fromString)).withMarkers(q.receive(s.getMarkers())).withText(q.receive(s.getText()))));
    }

    @Generated
    private static UUID $default$id() {
        return Tree.randomId();
    }

    @Generated
    private static Markers $default$markers() {
        return Markers.EMPTY;
    }

    @Generated
    private static String $default$text() {
        return "";
    }

    @NonNull
    @Generated
    public static PlainTextBuilder builder() {
        return new PlainTextBuilder();
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    @Generated
    public Markers getMarkers() {
        return this.markers;
    }

    @Generated
    public @Nullable String getCharsetName() {
        return this.charsetName;
    }

    @Override
    @Generated
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    @Generated
    public @Nullable FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @NonNull
    @Generated
    public String toString() {
        return "PlainText(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", checksum=" + this.getChecksum() + ", text=" + this.getText() + ", snippets=" + this.getSnippets() + ")";
    }

    @Generated
    private PlainText(UUID id, Path sourcePath, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Nullable Checksum checksum, String text, @Nullable List<Snippet> snippets, @Nullable SoftReference<SourceFileWithReferences.References> references) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.charsetName = charsetName;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
        this.checksum = checksum;
        this.text = text;
        this.snippets = snippets;
        this.references = references;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlainText)) {
            return false;
        }
        PlainText other = (PlainText)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public PlainText withId(UUID id) {
        return this.id == id ? this : new PlainText(id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text, this.snippets, this.references);
    }

    @NonNull
    @Generated
    public PlainText withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new PlainText(this.id, sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text, this.snippets, this.references);
    }

    @NonNull
    @Generated
    public PlainText withMarkers(Markers markers) {
        return this.markers == markers ? this : new PlainText(this.id, this.sourcePath, markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text, this.snippets, this.references);
    }

    @NonNull
    @Generated
    private PlainText withCharsetName(@Nullable String charsetName) {
        return this.charsetName == charsetName ? this : new PlainText(this.id, this.sourcePath, this.markers, charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text, this.snippets, this.references);
    }

    @NonNull
    @Generated
    public PlainText withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, charsetBomMarked, this.fileAttributes, this.checksum, this.text, this.snippets, this.references);
    }

    @NonNull
    @Generated
    public PlainText withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, fileAttributes, this.checksum, this.text, this.snippets, this.references);
    }

    @NonNull
    @Generated
    public PlainText withChecksum(@Nullable Checksum checksum) {
        return this.checksum == checksum ? this : new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, checksum, this.text, this.snippets, this.references);
    }

    @Override
    @Generated
    public @Nullable Checksum getChecksum() {
        return this.checksum;
    }

    @Generated
    public static class PlainTextBuilder {
        @Generated
        private boolean id$set;
        @Generated
        private UUID id$value;
        @Generated
        private Path sourcePath;
        @Generated
        private boolean markers$set;
        @Generated
        private Markers markers$value;
        @Generated
        private String charsetName;
        @Generated
        private boolean charsetBomMarked;
        @Generated
        private FileAttributes fileAttributes;
        @Generated
        private Checksum checksum;
        @Generated
        private boolean text$set;
        @Generated
        private String text$value;
        @Generated
        private List<Snippet> snippets;
        @Generated
        private SoftReference<SourceFileWithReferences.References> references;

        @Generated
        PlainTextBuilder() {
        }

        @NonNull
        @Generated
        public PlainTextBuilder id(UUID id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder sourcePath(Path sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder markers(Markers markers) {
            this.markers$value = markers;
            this.markers$set = true;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder charsetName(@Nullable String charsetName) {
            this.charsetName = charsetName;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder charsetBomMarked(boolean charsetBomMarked) {
            this.charsetBomMarked = charsetBomMarked;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder fileAttributes(@Nullable FileAttributes fileAttributes) {
            this.fileAttributes = fileAttributes;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder checksum(@Nullable Checksum checksum) {
            this.checksum = checksum;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder text(String text) {
            this.text$value = text;
            this.text$set = true;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder snippets(@Nullable List<Snippet> snippets) {
            this.snippets = snippets;
            return this;
        }

        @NonNull
        @Generated
        public PlainTextBuilder references(@Nullable SoftReference<SourceFileWithReferences.References> references) {
            this.references = references;
            return this;
        }

        @NonNull
        @Generated
        public PlainText build() {
            UUID id$value = this.id$value;
            if (!this.id$set) {
                id$value = PlainText.$default$id();
            }
            Markers markers$value = this.markers$value;
            if (!this.markers$set) {
                markers$value = PlainText.$default$markers();
            }
            String text$value = this.text$value;
            if (!this.text$set) {
                text$value = PlainText.$default$text();
            }
            return new PlainText(id$value, this.sourcePath, markers$value, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, text$value, this.snippets, this.references);
        }

        @NonNull
        @Generated
        public String toString() {
            return "PlainText.PlainTextBuilder(id$value=" + this.id$value + ", sourcePath=" + this.sourcePath + ", markers$value=" + this.markers$value + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.charsetBomMarked + ", fileAttributes=" + this.fileAttributes + ", checksum=" + this.checksum + ", text$value=" + this.text$value + ", snippets=" + this.snippets + ", references=" + this.references + ")";
        }
    }

    public static final class Snippet
    implements Tree {
        private final UUID id;
        private final Markers markers;
        private final String text;

        @Override
        public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
            return v.isAdaptableTo(PlainTextVisitor.class);
        }

        @Override
        public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
            return (R)v.adapt(PlainTextVisitor.class).visitSnippet(this, p);
        }

        @Override
        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new PlainTextPrinter();
        }

        @Generated
        public Snippet(UUID id, Markers markers, String text) {
            this.id = id;
            this.markers = markers;
            this.text = text;
        }

        @Override
        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Snippet)) {
                return false;
            }
            Snippet other = (Snippet)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !((Object)this$markers).equals(other$markers)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : ((Object)$markers).hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "PlainText.Snippet(id=" + this.getId() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        @NonNull
        @Generated
        public Snippet withId(UUID id) {
            return this.id == id ? this : new Snippet(id, this.markers, this.text);
        }

        @NonNull
        @Generated
        public Snippet withMarkers(Markers markers) {
            return this.markers == markers ? this : new Snippet(this.id, markers, this.text);
        }

        @NonNull
        @Generated
        public Snippet withText(String text) {
            return this.text == text ? this : new Snippet(this.id, this.markers, text);
        }
    }
}

