/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.text.PlainText;

public final class AppendToTextFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Relative file name", description="File name, using a relative path. If a non-plaintext file already exists at this location, then this recipe will do nothing.", example="foo/bar/baz.txt")
    private final String relativeFileName;
    @Option(displayName="Content", description="Multiline text content to be appended to the file.", example="Some text.")
    private final String content;
    @Option(displayName="Preamble", description="If a new file is created, this content will be included at the beginning.", example="# File generated by OpenRewrite #", required=false)
    private final @Nullable String preamble;
    @Option(displayName="Append newline", description="Print a newline automatically after the content (and preamble). Default true.", required=false)
    private final @Nullable Boolean appendNewline;
    @Option(displayName="Existing file strategy", description="Determines behavior if a file exists at this location prior to Rewrite execution.\n\n- `Continue`: append new content to existing file contents. If existing file is not plaintext, recipe does nothing.\n- `Replace`: remove existing content from file.\n- `Leave`: *(default)* do nothing. Existing file is fully preserved.\n\nNote: this only affects the first interaction with the specified file per Rewrite execution.\nSubsequent instances of this recipe in the same Rewrite execution will always append.", valid={"Continue", "Replace", "Leave"}, required=false)
    private final @Nullable Strategy existingFileStrategy;

    @Override
    public String getDisplayName() {
        return "Append to text file";
    }

    @Override
    public String getDescription() {
        return "Appends or replaces content of an existing plain text file, or creates a new one if it doesn't already exist. Please note that this recipes requires existing plain text files' format to be successfully parsable by OpenRewrite. If a file is left unchanged, it might be parsed as a `Quark` rather than plain text. In such case, use the `plainTextMask` option. See the [Gradle](https://docs.openrewrite.org/reference/gradle-plugin-configuration#configuring-the-rewrite-dsl) or [Maven](https://openrewrite.github.io/rewrite-maven-plugin/run-mojo.html#plainTextMasks) plugin configuration page.";
    }

    @Override
    public int maxCycles() {
        return 1;
    }

    @Override
    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean fileExists) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (!fileExists.get() && sourceFile.getSourcePath().toString().equals(Paths.get(AppendToTextFile.this.relativeFileName, new String[0]).toString())) {
                    fileExists.set(true);
                }
                return sourceFile;
            }
        };
    }

    @Override
    public Collection<PlainText> generate(AtomicBoolean fileExists, Collection<SourceFile> generatedInThisCycle, ExecutionContext ctx) {
        String maybeNewline = !Boolean.FALSE.equals(this.appendNewline) ? "\n" : "";
        String content = this.content + maybeNewline;
        String preamble = this.preamble != null ? this.preamble + maybeNewline : "";
        boolean exists = fileExists.get();
        Path path = Paths.get(this.relativeFileName, new String[0]);
        if (!exists) {
            for (SourceFile generated : generatedInThisCycle) {
                if (!generated.getSourcePath().toString().equals(path.toString())) continue;
                exists = true;
                break;
            }
        }
        return exists ? Collections.emptyList() : Collections.singletonList(PlainText.builder().text(preamble + content).sourcePath(path).build());
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean fileExists) {
        return Preconditions.check(fileExists.get(), new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile.getSourcePath().toString().equals(Paths.get(AppendToTextFile.this.relativeFileName, new String[0]).toString())) {
                    String maybeNewline = !Boolean.FALSE.equals(AppendToTextFile.this.appendNewline) ? "\n" : "";
                    String content = AppendToTextFile.this.content + maybeNewline;
                    String preamble = AppendToTextFile.this.preamble != null ? AppendToTextFile.this.preamble + maybeNewline : "";
                    PlainText existingPlainText = (PlainText)sourceFile;
                    switch ((AppendToTextFile.this.existingFileStrategy != null ? AppendToTextFile.this.existingFileStrategy : Strategy.Leave).ordinal()) {
                        case 0: {
                            if (!maybeNewline.isEmpty() && !existingPlainText.getText().endsWith(maybeNewline)) {
                                content = maybeNewline + content;
                            }
                            return existingPlainText.withText(existingPlainText.getText() + content);
                        }
                        case 1: {
                            return existingPlainText.withText(preamble + content);
                        }
                    }
                }
                return sourceFile;
            }
        });
    }

    @Generated
    public AppendToTextFile(String relativeFileName, String content, @Nullable String preamble, @Nullable Boolean appendNewline, @Nullable Strategy existingFileStrategy) {
        this.relativeFileName = relativeFileName;
        this.content = content;
        this.preamble = preamble;
        this.appendNewline = appendNewline;
        this.existingFileStrategy = existingFileStrategy;
    }

    @Generated
    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public @Nullable String getPreamble() {
        return this.preamble;
    }

    @Generated
    public @Nullable Boolean getAppendNewline() {
        return this.appendNewline;
    }

    @Generated
    public @Nullable Strategy getExistingFileStrategy() {
        return this.existingFileStrategy;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AppendToTextFile(relativeFileName=" + this.getRelativeFileName() + ", content=" + this.getContent() + ", preamble=" + this.getPreamble() + ", appendNewline=" + this.getAppendNewline() + ", existingFileStrategy=" + (Object)((Object)this.getExistingFileStrategy()) + ")";
    }

    @Override
    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppendToTextFile)) {
            return false;
        }
        AppendToTextFile other = (AppendToTextFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$appendNewline = this.getAppendNewline();
        Boolean other$appendNewline = other.getAppendNewline();
        if (this$appendNewline == null ? other$appendNewline != null : !((Object)this$appendNewline).equals(other$appendNewline)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        if (this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$preamble = this.getPreamble();
        String other$preamble = other.getPreamble();
        if (this$preamble == null ? other$preamble != null : !this$preamble.equals(other$preamble)) {
            return false;
        }
        Strategy this$existingFileStrategy = this.getExistingFileStrategy();
        Strategy other$existingFileStrategy = other.getExistingFileStrategy();
        return !(this$existingFileStrategy == null ? other$existingFileStrategy != null : !((Object)((Object)this$existingFileStrategy)).equals((Object)other$existingFileStrategy));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AppendToTextFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $appendNewline = this.getAppendNewline();
        result = result * 59 + ($appendNewline == null ? 43 : ((Object)$appendNewline).hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $preamble = this.getPreamble();
        result = result * 59 + ($preamble == null ? 43 : $preamble.hashCode());
        Strategy $existingFileStrategy = this.getExistingFileStrategy();
        result = result * 59 + ($existingFileStrategy == null ? 43 : ((Object)((Object)$existingFileStrategy)).hashCode());
        return result;
    }

    public static enum Strategy {
        Continue,
        Replace,
        Leave;

    }
}

