/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class ManagedThreadLocal<T extends AutoCloseable> {
    private final ThreadLocal<@Nullable PendingResource<T>> threadLocal = new ThreadLocal();

    public T require() {
        PendingResource<T> pending = this.threadLocal.get();
        if (pending == null) {
            throw new IllegalStateException("No managed resource found in current thread context");
        }
        return pending.getOrCreate();
    }

    public Scope<T> requireOrCreate(Supplier<T> factory) {
        PendingResource<T> existing = this.threadLocal.get();
        if (existing != null) {
            return new Scope<AutoCloseable>(existing::getOrCreate, () -> {});
        }
        PendingResource<T> pending = new PendingResource<T>(factory);
        this.threadLocal.set(pending);
        return new Scope<AutoCloseable>(pending::getOrCreate, () -> {
            Object resource = pending.getIfCreated();
            if (resource != null) {
                try {
                    this.threadLocal.remove();
                }
                finally {
                    try {
                        resource.close();
                    }
                    catch (Exception e) {
                        System.err.println("Error closing managed resource: " + e.getMessage());
                    }
                }
            }
        });
    }

    public Scope<T> create(Supplier<T> factory) {
        PendingResource<T> previousValue = this.threadLocal.get();
        PendingResource<T> pending = new PendingResource<T>(factory);
        this.threadLocal.set(pending);
        return new Scope<AutoCloseable>(pending::getOrCreate, () -> {
            Object resource = pending.getIfCreated();
            try {
                if (previousValue != null) {
                    this.threadLocal.set(previousValue);
                } else {
                    this.threadLocal.remove();
                }
            }
            finally {
                if (resource != null) {
                    try {
                        resource.close();
                    }
                    catch (Exception e) {
                        System.err.println("Error closing created resource: " + e.getMessage());
                    }
                }
            }
        });
    }

    public Scope<T> using(T value) {
        PendingResource<T> previousValue = this.threadLocal.get();
        PendingResource<AutoCloseable> pending = new PendingResource<AutoCloseable>(() -> value);
        this.threadLocal.set(pending);
        return new Scope<AutoCloseable>(() -> value, () -> {
            if (previousValue != null) {
                this.threadLocal.set(previousValue);
            } else {
                this.threadLocal.remove();
            }
        });
    }

    public boolean isPresent() {
        return this.threadLocal.get() != null;
    }

    private static class PendingResource<T extends AutoCloseable> {
        final Supplier<T> factory;
        final AtomicReference<@Nullable T> resourceRef = new AtomicReference();

        T getOrCreate() {
            AutoCloseable resource = (AutoCloseable)this.resourceRef.get();
            if (resource == null) {
                resource = (AutoCloseable)this.factory.get();
                this.resourceRef.set(resource);
            }
            return (T)resource;
        }

        @Nullable T getIfCreated() {
            return (T)((AutoCloseable)this.resourceRef.get());
        }

        @Generated
        public PendingResource(Supplier<T> factory) {
            this.factory = factory;
        }
    }

    public static class Scope<T extends AutoCloseable>
    implements AutoCloseable {
        private final Supplier<T> resourceSupplier;
        private final AutoCloseable cleanup;

        Scope(Supplier<T> resourceSupplier, AutoCloseable cleanup) {
            this.resourceSupplier = resourceSupplier;
            this.cleanup = cleanup;
        }

        public <R> R map(Function<T, R> mapper) {
            return mapper.apply((AutoCloseable)this.resourceSupplier.get());
        }

        @Override
        public void close() {
            try {
                this.cleanup.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

