/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class MoveFile
extends Recipe {
    @Option(displayName="Folder", description="When using the folder option, all files / subfolders in the folder will be moved to the moveTo source path. Folder should be starting at root", required=false, example="src/main/resources/")
    private final @org.jspecify.annotations.Nullable String folder;
    @Option(displayName="File matcher", description="Matching files will be moved. This is a glob expression.", required=false, example="**/*.yml")
    private final @org.jspecify.annotations.Nullable String fileMatcher;
    @Option(displayName="Move to", description="Either a relative or absolute path. If relative, it is relative to the current file's directory.", example="../yamls/")
    private final String moveTo;

    @Override
    public String getDisplayName() {
        return "Move a file";
    }

    @Override
    public String getDescription() {
        return "Move a file to a different directory. The file name will remain the same.";
    }

    @Override
    public Validated<Object> validate() {
        Validated<Object> validated = super.validate();
        if (StringUtils.isNullOrEmpty(this.folder) && StringUtils.isNullOrEmpty(this.fileMatcher)) {
            return validated.and(Validated.invalid("folder", this.folder, "folder or fileMatcher must be set")).and(Validated.invalid("fileMatcher", this.fileMatcher, "folder or fileMatcher must be set"));
        }
        if (!StringUtils.isNullOrEmpty(this.folder) && !StringUtils.isNullOrEmpty(this.fileMatcher)) {
            return validated.and(Validated.invalid("folder", this.folder, "folder and fileMatcher cannot both be set")).and(Validated.invalid("fileMatcher", this.fileMatcher, "folder and fileMatcher cannot both be set"));
        }
        return validated;
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @org.jspecify.annotations.Nullable Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    boolean isFileOnRoot;
                    String originalSourcePath = ((SourceFile)tree).getSourcePath().toString();
                    Path sourcePath = Paths.get(PathUtils.separatorsToSystem(originalSourcePath), new String[0]);
                    boolean isWindowsPath = originalSourcePath.equals(PathUtils.separatorsToWindows(originalSourcePath));
                    boolean isUnixPath = originalSourcePath.equals(PathUtils.separatorsToUnix(originalSourcePath));
                    boolean bl = isFileOnRoot = sourcePath.getParent() == null;
                    if (!isFileOnRoot && (isWindowsPath && isUnixPath || !isWindowsPath && !isUnixPath)) {
                        return tree;
                    }
                    Path destination = MoveFile.this.folder() != null ? this.getFolderTarget(sourcePath, MoveFile.this.moveTo()) : this.getFilePatternTarget(sourcePath, MoveFile.this.moveTo());
                    if (destination != null && !destination.equals(sourcePath) && !(destination = destination.resolve(sourcePath.getFileName().toString())).equals(sourcePath)) {
                        if (isFileOnRoot) {
                            return ((SourceFile)tree).withSourcePath(Paths.get(PathUtils.separatorsToSystem(destination.toString()), new String[0]));
                        }
                        if (isWindowsPath) {
                            return ((SourceFile)tree).withSourcePath(Paths.get(PathUtils.separatorsToWindows(destination.toString()), new String[0]));
                        }
                        return ((SourceFile)tree).withSourcePath(Paths.get(PathUtils.separatorsToUnix(destination.toString()), new String[0]));
                    }
                }
                return super.visit(tree, ctx);
            }

            private @org.jspecify.annotations.Nullable Path getFolderTarget(Path sourcePath, String destinationPattern) {
                String folder = MoveFile.this.folder();
                if (folder == null) {
                    return null;
                }
                String folderPrefix = folder;
                if (!folderPrefix.endsWith("/**")) {
                    folderPrefix = folderPrefix.endsWith("/") ? folderPrefix + "**" : folderPrefix + "/**";
                }
                Path currentFolder = sourcePath.getParent();
                if (PathUtils.matchesGlob(sourcePath, folderPrefix) || folderPrefix.equals("/**")) {
                    String subFolders;
                    String string = subFolders = currentFolder == null ? "" : currentFolder.toString().substring(folder.length());
                    if (subFolders.startsWith("/") || subFolders.startsWith("\\")) {
                        subFolders = subFolders.substring(1);
                    }
                    Path destination = null;
                    if (destinationPattern.startsWith("../")) {
                        destination = this.moveToRelativePath(Paths.get(folderPrefix.substring(0, folderPrefix.length() - 3), new String[0]), destinationPattern);
                    } else if (!subFolders.equals(destinationPattern.startsWith("/") ? destinationPattern.substring(1) : destinationPattern) && !subFolders.startsWith(destinationPattern.startsWith("/") ? destinationPattern.substring(1) : destinationPattern + "/")) {
                        destination = destinationPattern.startsWith("/") ? this.moveToAbsolutePath() : Paths.get(folder, destinationPattern);
                    }
                    if (destination != null) {
                        return destination.resolve(subFolders);
                    }
                    return null;
                }
                return sourcePath;
            }

            private @org.jspecify.annotations.Nullable Path getFilePatternTarget(Path sourcePath, String destinationPattern) {
                if (MoveFile.this.fileMatcher == null) {
                    return null;
                }
                if (sourcePath.getFileSystem().getPathMatcher("glob:" + MoveFile.this.fileMatcher).matches(sourcePath)) {
                    Path currentFolder = sourcePath.getParent();
                    if (destinationPattern.startsWith("/")) {
                        return this.moveToAbsolutePath();
                    }
                    if (destinationPattern.startsWith("../")) {
                        return this.moveToRelativePath(currentFolder, destinationPattern);
                    }
                    if (currentFolder != null && !currentFolder.endsWith(destinationPattern)) {
                        return currentFolder.resolve(destinationPattern);
                    }
                    if (currentFolder == null) {
                        return Paths.get(destinationPattern, new String[0]);
                    }
                }
                return sourcePath;
            }

            private Path moveToAbsolutePath() {
                return Paths.get(MoveFile.this.moveTo().substring(1), new String[0]);
            }

            private @org.jspecify.annotations.Nullable Path moveToRelativePath(@org.jspecify.annotations.Nullable Path sourcePath, String relativePath) {
                Path moveToSourcePath = sourcePath;
                String moveToPath = relativePath;
                while (moveToPath.startsWith("../")) {
                    Path path = moveToSourcePath = moveToSourcePath != null ? moveToSourcePath.getParent() : null;
                    if (moveToSourcePath == null) {
                        return null;
                    }
                    moveToPath = moveToPath.substring(3);
                }
                return moveToSourcePath != null ? moveToSourcePath.resolve(moveToPath) : null;
            }
        };
    }

    private @org.jspecify.annotations.Nullable String folder() {
        if (StringUtils.isNullOrEmpty(this.folder)) {
            return null;
        }
        return PathUtils.separatorsToUnix(this.folder.startsWith("/") || this.folder.startsWith("\\") ? this.folder.substring(1) : this.folder);
    }

    private String moveTo() {
        return PathUtils.separatorsToUnix(this.moveTo);
    }

    @Generated
    public MoveFile(@org.jspecify.annotations.Nullable String folder, @org.jspecify.annotations.Nullable String fileMatcher, String moveTo) {
        this.folder = folder;
        this.fileMatcher = fileMatcher;
        this.moveTo = moveTo;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getFolder() {
        return this.folder;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @Generated
    public String getMoveTo() {
        return this.moveTo;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MoveFile(folder=" + this.getFolder() + ", fileMatcher=" + this.getFileMatcher() + ", moveTo=" + this.getMoveTo() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveFile)) {
            return false;
        }
        MoveFile other = (MoveFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$folder = this.getFolder();
        String other$folder = other.getFolder();
        if (this$folder == null ? other$folder != null : !this$folder.equals(other$folder)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        if (this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher)) {
            return false;
        }
        String this$moveTo = this.getMoveTo();
        String other$moveTo = other.getMoveTo();
        return !(this$moveTo == null ? other$moveTo != null : !this$moveTo.equals(other$moveTo));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MoveFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : $folder.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        String $moveTo = this.getMoveTo();
        result = result * 59 + ($moveTo == null ? 43 : $moveTo.hashCode());
        return result;
    }
}

