/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.semver.VersionComparator;

public class LatestRelease
implements VersionComparator {
    private final @Nullable String metadataPattern;

    public LatestRelease(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    protected @Nullable String getMetadataPattern() {
        return this.metadataPattern;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return VersionComparator.checkVersion(version, this.metadataPattern, true);
    }

    static String normalizeVersion(String version) {
        int versionParts;
        int lastDotIdx = version.lastIndexOf(46);
        for (String suffix : RELEASE_SUFFIXES) {
            if (!version.regionMatches(true, lastDotIdx, suffix, 0, suffix.length())) continue;
            version = version.substring(0, lastDotIdx);
            break;
        }
        if ((versionParts = LatestRelease.countVersionParts(version)) <= 2) {
            String[] versionAndMetadata = version.split("(?=[-+])");
            while (versionParts <= 2) {
                versionAndMetadata[0] = versionAndMetadata[0] + ".0";
                ++versionParts;
            }
            version = versionAndMetadata.length > 1 ? versionAndMetadata[0] + versionAndMetadata[1] : versionAndMetadata[0];
        }
        return version;
    }

    static int countVersionParts(String version) {
        int count = 0;
        int len = version.length();
        int lastSepIdx = -1;
        for (int i = 0; i < len; ++i) {
            char c = version.charAt(i);
            if (c == '.' || c == '-' || c == '$') {
                if (lastSepIdx == i - 1) {
                    return count;
                }
                lastSepIdx = i;
                continue;
            }
            if (lastSepIdx != i - 1) continue;
            if (!Character.isDigit(c)) break;
            ++count;
        }
        return count;
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        int v2Prio;
        int i;
        int vp2;
        if (v1.equalsIgnoreCase(v2)) {
            return 0;
        }
        if (v1.equalsIgnoreCase("LATEST") || v1.equalsIgnoreCase("latest.integration")) {
            return 1;
        }
        if (v2.equalsIgnoreCase("LATEST") || v2.equalsIgnoreCase("latest.integration")) {
            return -1;
        }
        if (v1.equalsIgnoreCase("RELEASE") || v1.equalsIgnoreCase("latest.release")) {
            return 1;
        }
        if (v2.equalsIgnoreCase("RELEASE") || v2.equalsIgnoreCase("latest.release")) {
            return -1;
        }
        String nv1 = LatestRelease.normalizeVersion(v1);
        String nv2 = LatestRelease.normalizeVersion(v2);
        int vp1 = LatestRelease.countVersionParts(nv1);
        if (vp1 > (vp2 = LatestRelease.countVersionParts(nv2))) {
            StringBuilder nv2Builder = new StringBuilder(nv2);
            for (i = vp2; i < vp1; ++i) {
                nv2Builder.append(".0");
            }
            nv2 = nv2Builder.toString();
        } else if (vp2 > vp1) {
            StringBuilder nv1Builder = new StringBuilder(nv1);
            for (i = vp1; i < vp2; ++i) {
                nv1Builder.append(".0");
            }
            nv1 = nv1Builder.toString();
        }
        String normalized1 = this.metadataPattern == null ? nv1 : nv1.replaceAll(this.metadataPattern, "");
        String normalized2 = this.metadataPattern == null ? nv2 : nv2.replaceAll(this.metadataPattern, "");
        Matcher v1Gav = VersionComparator.RELEASE_PATTERN.matcher(normalized1);
        Matcher v2Gav = VersionComparator.RELEASE_PATTERN.matcher(normalized2);
        v1Gav.find();
        v2Gav.find();
        try {
            for (int i2 = 1; i2 <= Math.max(vp1, vp2); ++i2) {
                String v1Part = v1Gav.group(i2);
                String v2Part = v2Gav.group(i2);
                if (v1Part == null) {
                    return v2Part == null ? normalized1.compareTo(normalized2) : -1;
                }
                if (v2Part == null) {
                    return 1;
                }
                long diff = Long.parseLong(v1Part) - Long.parseLong(v2Part);
                if (diff == 0L) continue;
                return (int)(diff / Math.abs(diff));
            }
        }
        catch (IllegalStateException exception) {
            throw new IllegalStateException("Illegal state while comparing versions : [" + nv1 + "] and [" + nv2 + "]. Metadata = [" + this.metadataPattern + "]", exception);
        }
        int v1Prio = LatestRelease.qualifierPriority(v1Gav.group(6));
        if (v1Prio != (v2Prio = LatestRelease.qualifierPriority(v2Gav.group(6)))) {
            return Integer.compare(v1Prio, v2Prio);
        }
        return normalized1.compareTo(normalized2);
    }

    private static int qualifierPriority(@Nullable String suffix) {
        String qualifier;
        switch (qualifier = LatestRelease.extractQualifier(suffix)) {
            case "alpha": 
            case "a": {
                return 1;
            }
            case "beta": 
            case "b": {
                return 2;
            }
            case "milestone": 
            case "m": {
                return 3;
            }
            case "rc": 
            case "cr": {
                return 4;
            }
            case "snapshot": {
                return 5;
            }
            case "": 
            case "ga": 
            case "final": 
            case "release": {
                return 6;
            }
            case "sp": {
                return 7;
            }
        }
        return 8;
    }

    private static String extractQualifier(@Nullable String suffix) {
        if (suffix == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < suffix.length() && Character.isLetter(suffix.charAt(i)); ++i) {
            builder.append(Character.toLowerCase(suffix.charAt(i)));
        }
        return builder.toString();
    }

    public static Validated<LatestRelease> buildLatestRelease(String toVersion, @Nullable String metadataPattern) {
        return "latest.release".equalsIgnoreCase(toVersion) || "latest.major".equalsIgnoreCase(toVersion) ? Validated.valid("latestRelease", new LatestRelease(metadataPattern)) : Validated.invalid("latestRelease", toVersion, "not latest release");
    }
}

