/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.GitRemote;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.jgit.api.Git;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.PersonIdent;
import org.openrewrite.jgit.lib.Ref;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.lib.RepositoryBuilder;
import org.openrewrite.jgit.lib.StoredConfig;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.transport.RemoteConfig;
import org.openrewrite.jgit.treewalk.WorkingTreeOptions;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;
import org.openrewrite.marker.ci.JenkinsBuildEnvironment;
import org.openrewrite.rpc.Reference;

public final class GitProvenance
extends Reference
implements Marker {
    private final UUID id;
    private final @Nullable String origin;
    private final @Nullable String branch;
    private final @Nullable String change;
    private final @Nullable AutoCRLF autocrlf;
    private final @Nullable EOL eol;
    @Incubating(since="8.9.0")
    private final @Nullable List<Committer> committers;
    @Incubating(since="8.33.0")
    private @Nullable GitRemote gitRemote;

    @JsonCreator
    public GitProvenance(UUID id, @Nullable String origin, @Nullable String branch, @Nullable String change, @Nullable AutoCRLF autocrlf, @Nullable EOL eol, @Nullable List<Committer> committers) {
        this.id = id;
        this.origin = origin;
        this.branch = branch;
        this.change = change;
        this.autocrlf = autocrlf;
        this.eol = eol;
        this.committers = committers;
    }

    @Override
    public Object getValue() {
        return this;
    }

    public @Nullable GitRemote getGitRemote() {
        if (this.gitRemote == null && this.origin != null) {
            this.gitRemote = new GitRemote.Parser().parse(this.origin);
        }
        return this.gitRemote;
    }

    public @Nullable String getOrganizationName(String baseUrl) {
        if (this.origin == null) {
            return null;
        }
        int schemeEndIndex = baseUrl.indexOf("://");
        if (schemeEndIndex != -1) {
            baseUrl = baseUrl.substring(schemeEndIndex + 3);
        }
        if (baseUrl.startsWith("git@")) {
            baseUrl = baseUrl.substring(4);
        }
        String remainder = this.origin.substring(this.origin.indexOf(baseUrl) + baseUrl.length()).replaceFirst("^:", "").replaceFirst("^/", "");
        return remainder.substring(0, remainder.lastIndexOf(47));
    }

    public @Nullable String getOrganizationName() {
        if (this.getGitRemote() == null) {
            return null;
        }
        return this.getGitRemote().getOrganization();
    }

    public @Nullable String getRepositoryName() {
        if (this.getGitRemote() == null) {
            return null;
        }
        return this.getGitRemote().getRepositoryName();
    }

    public @Nullable String getRepositoryPath() {
        if (this.getGitRemote() == null) {
            return null;
        }
        return this.getGitRemote().getPath();
    }

    public @Nullable String getRepositoryOrigin() {
        if (this.getGitRemote() == null) {
            return null;
        }
        return this.getGitRemote().getOrigin();
    }

    @Deprecated
    public static @Nullable GitProvenance fromProjectDirectory(Path projectDir) {
        return GitProvenance.fromProjectDirectory(projectDir, null);
    }

    public static @Nullable GitProvenance fromProjectDirectory(Path projectDir, @Nullable BuildEnvironment environment) {
        return GitProvenance.fromProjectDirectory(projectDir, environment, null);
    }

    public static @Nullable GitProvenance fromProjectDirectory(Path projectDir, @Nullable BuildEnvironment environment, @Nullable GitRemote.Parser gitRemoteParser) {
        if (gitRemoteParser == null) {
            gitRemoteParser = new GitRemote.Parser();
        }
        if (environment != null) {
            if (environment instanceof JenkinsBuildEnvironment) {
                GitProvenance gitProvenance;
                block15: {
                    JenkinsBuildEnvironment jenkinsBuildEnvironment = (JenkinsBuildEnvironment)environment;
                    Repository repository = ((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir.toFile())).build();
                    try {
                        String branch = jenkinsBuildEnvironment.getLocalBranch() != null ? jenkinsBuildEnvironment.getLocalBranch() : GitProvenance.localBranchName(repository, jenkinsBuildEnvironment.getBranch());
                        gitProvenance = GitProvenance.fromGitConfig(repository, branch, GitProvenance.getChangeset(repository), gitRemoteParser);
                        if (repository == null) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (repository != null) {
                                try {
                                    repository.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IllegalArgumentException | GitAPIException e) {
                            GitProvenance.printRequireGitDirOrWorkTreeException((Exception)e);
                            return null;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    repository.close();
                }
                return gitProvenance;
            }
            File gitDir = ((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir.toFile())).getGitDir();
            if (gitDir != null && gitDir.exists()) {
                return GitProvenance.fromGitConfig(projectDir, gitRemoteParser);
            }
            try {
                return environment.buildGitProvenance();
            }
            catch (IncompleteGitConfigException e) {
                return GitProvenance.fromGitConfig(projectDir, gitRemoteParser);
            }
        }
        return GitProvenance.fromGitConfig(projectDir, gitRemoteParser);
    }

    private static void printRequireGitDirOrWorkTreeException(Exception e) {
        if (!"requireGitDirOrWorkTree".equals(e.getStackTrace()[0].getMethodName())) {
            e.printStackTrace();
        }
    }

    private static @Nullable GitProvenance fromGitConfig(Path projectDir, GitRemote.Parser gitRemoteParser) {
        GitProvenance gitProvenance;
        block10: {
            String branch = null;
            Repository repository = ((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir.toFile())).build();
            try {
                String changeset = GitProvenance.getChangeset(repository);
                if (!repository.getBranch().equals(changeset)) {
                    branch = repository.getBranch();
                }
                gitProvenance = GitProvenance.fromGitConfig(repository, branch, changeset, gitRemoteParser);
                if (repository == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    GitProvenance.printRequireGitDirOrWorkTreeException(e);
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            repository.close();
        }
        return gitProvenance;
    }

    private static @Nullable GitProvenance fromGitConfig(Repository repository, @Nullable String branch, @Nullable String changeset, GitRemote.Parser gitRemoteParser) {
        String remoteOriginUrl;
        if (repository.isBare()) {
            return null;
        }
        if (branch == null) {
            branch = GitProvenance.resolveBranchFromGitConfig(repository);
        }
        GitRemote remote = (remoteOriginUrl = GitProvenance.getRemoteOriginUrl(repository)) == null ? null : gitRemoteParser.parse(remoteOriginUrl);
        return new GitProvenance(Tree.randomId(), remoteOriginUrl, branch, changeset, GitProvenance.getAutocrlf(repository), GitProvenance.getEOF(repository), GitProvenance.getCommitters(repository), remote);
    }

    static @Nullable String resolveBranchFromGitConfig(Repository repository) {
        String branch;
        try (Git git = Git.open((File)repository.getDirectory());){
            ObjectId commit = repository.resolve("HEAD");
            Map branchesByCommit = git.nameRev().addPrefix("refs/heads/").add(commit).call();
            if (branchesByCommit.containsKey(commit)) {
                branch = (String)branchesByCommit.get(commit);
            } else {
                branchesByCommit = git.nameRev().add(commit).call();
                branch = GitProvenance.localBranchName(repository, (String)branchesByCommit.get(commit));
            }
            if (branch != null) {
                if (branch.contains("^")) {
                    branch = branch.substring(0, branch.indexOf(94));
                } else if (branch.contains("~")) {
                    branch = branch.substring(0, branch.indexOf(126));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalArgumentException | GitAPIException e) {
            if (!"requireGitDirOrWorkTree".equals(e.getStackTrace()[0].getMethodName())) {
                e.printStackTrace();
            }
            return null;
        }
        return branch;
    }

    private static @Nullable String localBranchName(Repository repository, @Nullable String remoteBranch) throws IOException, GitAPIException {
        if (remoteBranch == null) {
            return null;
        }
        if (remoteBranch.startsWith("remotes/")) {
            remoteBranch = remoteBranch.substring(8);
        }
        String branch = null;
        try (Git git = Git.open((File)repository.getDirectory());){
            List remotes = git.remoteList().call();
            for (RemoteConfig remote : remotes) {
                if (!remoteBranch.startsWith(remote.getName()) || branch != null && branch.length() <= remoteBranch.length() - remote.getName().length() - 1) continue;
                branch = remoteBranch.substring(remote.getName().length() + 1);
            }
        }
        catch (GitAPIException gitAPIException) {
            // empty catch block
        }
        return branch;
    }

    private static @Nullable String getRemoteOriginUrl(Repository repository) {
        StoredConfig storedConfig = repository.getConfig();
        String url = storedConfig.getString("remote", "origin", "url");
        if (url == null) {
            return null;
        }
        if (url.startsWith("https://") || url.startsWith("http://")) {
            url = GitProvenance.hideSensitiveInformation(url);
        }
        return url;
    }

    private static @Nullable AutoCRLF getAutocrlf(Repository repository) {
        WorkingTreeOptions opt = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
        switch (opt.getAutoCRLF()) {
            case FALSE: {
                return AutoCRLF.False;
            }
            case TRUE: {
                return AutoCRLF.True;
            }
            case INPUT: {
                return AutoCRLF.Input;
            }
        }
        return null;
    }

    private static @Nullable EOL getEOF(Repository repository) {
        WorkingTreeOptions opt = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
        switch (opt.getEOL()) {
            case CRLF: {
                return EOL.CRLF;
            }
            case LF: {
                return EOL.LF;
            }
            case NATIVE: {
                return EOL.Native;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Committer> getCommitters(Repository repository) {
        try (Git git = Git.open((File)repository.getDirectory());){
            ObjectId head = repository.readOrigHead();
            if (head == null) {
                Ref headRef = repository.getRefDatabase().findRef("HEAD");
                if (headRef == null || headRef.getObjectId() == null) {
                    List<Committer> list = Collections.emptyList();
                    return list;
                }
                head = headRef.getObjectId();
            }
            HashMap<String, String> committerName = new HashMap<String, String>();
            HashMap<String, NavigableMap> commitMap = new HashMap<String, NavigableMap>();
            for (RevCommit commit : git.log().add((AnyObjectId)head).call()) {
                PersonIdent who = commit.getAuthorIdent();
                committerName.putIfAbsent(who.getEmailAddress(), who.getName());
                commitMap.computeIfAbsent(who.getEmailAddress(), email -> new TreeMap()).compute(who.getWhen().toInstant().atZone(who.getTimeZone().toZoneId()).toLocalDate(), (day, count) -> count == null ? 1 : count + 1);
            }
            List list = committerName.entrySet().stream().map(c -> new Committer((String)c.getValue(), (String)c.getKey(), (NavigableMap)commitMap.get(c.getKey()))).collect(Collectors.toList());
            return list;
        }
        catch (IOException | GitAPIException e) {
            return Collections.emptyList();
        }
    }

    private static @Nullable String getChangeset(Repository repository) throws IOException {
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return null;
        }
        return head.getName();
    }

    private static String hideSensitiveInformation(String url) {
        try {
            String credentials = URI.create(url).toURL().getUserInfo();
            if (credentials != null) {
                return url.replaceFirst(credentials, credentials.replaceFirst(":.*", ""));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to remove credentials from repository URL. {0}", e);
        }
        return url;
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public @Nullable String getOrigin() {
        return this.origin;
    }

    @Generated
    public @Nullable String getBranch() {
        return this.branch;
    }

    @Generated
    public @Nullable String getChange() {
        return this.change;
    }

    @Generated
    public @Nullable AutoCRLF getAutocrlf() {
        return this.autocrlf;
    }

    @Generated
    public @Nullable EOL getEol() {
        return this.eol;
    }

    @Generated
    public @Nullable List<Committer> getCommitters() {
        return this.committers;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitProvenance)) {
            return false;
        }
        GitProvenance other = (GitProvenance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$change = this.getChange();
        String other$change = other.getChange();
        if (this$change == null ? other$change != null : !this$change.equals(other$change)) {
            return false;
        }
        AutoCRLF this$autocrlf = this.getAutocrlf();
        AutoCRLF other$autocrlf = other.getAutocrlf();
        if (this$autocrlf == null ? other$autocrlf != null : !((Object)((Object)this$autocrlf)).equals((Object)other$autocrlf)) {
            return false;
        }
        EOL this$eol = this.getEol();
        EOL other$eol = other.getEol();
        if (this$eol == null ? other$eol != null : !((Object)((Object)this$eol)).equals((Object)other$eol)) {
            return false;
        }
        List<Committer> this$committers = this.getCommitters();
        List<Committer> other$committers = other.getCommitters();
        if (this$committers == null ? other$committers != null : !((Object)this$committers).equals(other$committers)) {
            return false;
        }
        GitRemote this$gitRemote = this.getGitRemote();
        GitRemote other$gitRemote = other.getGitRemote();
        return !(this$gitRemote == null ? other$gitRemote != null : !((Object)this$gitRemote).equals(other$gitRemote));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof GitProvenance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $change = this.getChange();
        result = result * 59 + ($change == null ? 43 : $change.hashCode());
        AutoCRLF $autocrlf = this.getAutocrlf();
        result = result * 59 + ($autocrlf == null ? 43 : ((Object)((Object)$autocrlf)).hashCode());
        EOL $eol = this.getEol();
        result = result * 59 + ($eol == null ? 43 : ((Object)((Object)$eol)).hashCode());
        List<Committer> $committers = this.getCommitters();
        result = result * 59 + ($committers == null ? 43 : ((Object)$committers).hashCode());
        GitRemote $gitRemote = this.getGitRemote();
        result = result * 59 + ($gitRemote == null ? 43 : ((Object)$gitRemote).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GitProvenance(id=" + this.getId() + ", origin=" + this.getOrigin() + ", branch=" + this.getBranch() + ", change=" + this.getChange() + ", autocrlf=" + (Object)((Object)this.getAutocrlf()) + ", eol=" + (Object)((Object)this.getEol()) + ", committers=" + this.getCommitters() + ", gitRemote=" + this.getGitRemote() + ")";
    }

    @Generated
    GitProvenance(UUID id, @Nullable String origin, @Nullable String branch, @Nullable String change, @Nullable AutoCRLF autocrlf, @Nullable EOL eol, @Nullable List<Committer> committers, @Nullable GitRemote gitRemote) {
        this.id = id;
        this.origin = origin;
        this.branch = branch;
        this.change = change;
        this.autocrlf = autocrlf;
        this.eol = eol;
        this.committers = committers;
        this.gitRemote = gitRemote;
    }

    @NonNull
    @Generated
    public GitProvenance withId(UUID id) {
        return this.id == id ? this : new GitProvenance(id, this.origin, this.branch, this.change, this.autocrlf, this.eol, this.committers, this.gitRemote);
    }

    @NonNull
    @Generated
    public GitProvenance withOrigin(@Nullable String origin) {
        return this.origin == origin ? this : new GitProvenance(this.id, origin, this.branch, this.change, this.autocrlf, this.eol, this.committers, this.gitRemote);
    }

    @NonNull
    @Generated
    public GitProvenance withBranch(@Nullable String branch) {
        return this.branch == branch ? this : new GitProvenance(this.id, this.origin, branch, this.change, this.autocrlf, this.eol, this.committers, this.gitRemote);
    }

    @NonNull
    @Generated
    public GitProvenance withChange(@Nullable String change) {
        return this.change == change ? this : new GitProvenance(this.id, this.origin, this.branch, change, this.autocrlf, this.eol, this.committers, this.gitRemote);
    }

    @NonNull
    @Generated
    public GitProvenance withAutocrlf(@Nullable AutoCRLF autocrlf) {
        return this.autocrlf == autocrlf ? this : new GitProvenance(this.id, this.origin, this.branch, this.change, autocrlf, this.eol, this.committers, this.gitRemote);
    }

    @NonNull
    @Generated
    public GitProvenance withEol(@Nullable EOL eol) {
        return this.eol == eol ? this : new GitProvenance(this.id, this.origin, this.branch, this.change, this.autocrlf, eol, this.committers, this.gitRemote);
    }

    @NonNull
    @Generated
    public GitProvenance withCommitters(@Nullable List<Committer> committers) {
        return this.committers == committers ? this : new GitProvenance(this.id, this.origin, this.branch, this.change, this.autocrlf, this.eol, committers, this.gitRemote);
    }

    @NonNull
    @Generated
    public GitProvenance withGitRemote(@Nullable GitRemote gitRemote) {
        return this.gitRemote == gitRemote ? this : new GitProvenance(this.id, this.origin, this.branch, this.change, this.autocrlf, this.eol, this.committers, gitRemote);
    }

    public static enum AutoCRLF {
        False,
        True,
        Input;

    }

    public static enum EOL {
        CRLF,
        LF,
        Native;

    }

    public static final class Committer {
        private final String name;
        private final String email;
        private final int[] data;

        @JsonCreator
        static Committer from(@JsonProperty(value="name") String name, @JsonProperty(value="email") String email, @JsonProperty(value="dates") int @Nullable [] data, @JsonProperty(value="commitsByDay") @Nullable NavigableMap<LocalDate, Integer> commitsByDay) {
            if (commitsByDay != null) {
                return new Committer(name, email, commitsByDay);
            }
            return new Committer(name, email, Objects.requireNonNull(data));
        }

        public Committer(String name, String email, NavigableMap<LocalDate, Integer> commitsByDay) {
            this.name = name;
            this.email = email;
            this.data = new int[commitsByDay.size() * 2];
            int i = 0;
            for (Map.Entry entry : commitsByDay.entrySet()) {
                this.data[i++] = (int)((LocalDate)entry.getKey()).toEpochDay();
                this.data[i++] = (Integer)entry.getValue();
            }
        }

        public NavigableMap<LocalDate, Integer> getCommitsByDay() {
            TreeMap<LocalDate, Integer> commitsByDay = new TreeMap<LocalDate, Integer>();
            int i = 0;
            while (i < this.data.length) {
                commitsByDay.put(LocalDate.ofEpochDay(this.data[i++]), this.data[i++]);
            }
            return commitsByDay;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Committer)) {
                return false;
            }
            Committer other = (Committer)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            return Arrays.equals(this.getData(), other.getData());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            result = result * 59 + Arrays.hashCode(this.getData());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "GitProvenance.Committer(name=" + this.getName() + ", email=" + this.getEmail() + ", data=" + Arrays.toString(this.getData()) + ")";
        }

        @Generated
        private Committer(String name, String email, int[] data) {
            this.name = name;
            this.email = email;
            this.data = data;
        }

        @NonNull
        @Generated
        public Committer withName(String name) {
            return this.name == name ? this : new Committer(name, this.email, this.data);
        }

        @NonNull
        @Generated
        public Committer withEmail(String email) {
            return this.email == email ? this : new Committer(this.name, email, this.data);
        }

        @Generated
        private int[] getData() {
            return this.data;
        }
    }
}

