/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.SearchResult;

public class PrintOutputCapture<P>
implements Cloneable {
    private final P p;
    private final MarkerPrinter markerPrinter;
    public final StringBuilder out = new StringBuilder();

    public PrintOutputCapture(P p) {
        this.p = p;
        this.markerPrinter = MarkerPrinter.DEFAULT;
    }

    public PrintOutputCapture(P p, MarkerPrinter markerPrinter) {
        this.p = p;
        this.markerPrinter = markerPrinter;
    }

    public P getContext() {
        return this.p;
    }

    public MarkerPrinter getMarkerPrinter() {
        return this.markerPrinter;
    }

    public String getOut() {
        return this.out.toString();
    }

    public PrintOutputCapture<P> append(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return this;
        }
        this.out.append(text);
        return this;
    }

    public PrintOutputCapture<P> append(char c) {
        this.out.append(c);
        return this;
    }

    public PrintOutputCapture<P> clone() {
        return new PrintOutputCapture<P>(this.p, this.markerPrinter);
    }

    public static interface MarkerPrinter {
        public static final MarkerPrinter DEFAULT = new MarkerPrinter(){

            @Override
            public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
                return marker.print(cursor, commentWrapper, false);
            }
        };
        public static final MarkerPrinter VERBOSE = new MarkerPrinter(){

            @Override
            public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
                return marker.print(cursor, commentWrapper, true);
            }
        };
        public static final MarkerPrinter FENCED = new MarkerPrinter(){

            @Override
            public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
                return marker instanceof SearchResult || marker instanceof Markup ? "{{" + marker.getId() + "}}" : "";
            }

            @Override
            public String afterSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
                return marker instanceof SearchResult || marker instanceof Markup ? "{{" + marker.getId() + "}}" : "";
            }
        };
        public static final MarkerPrinter SANITIZED = new MarkerPrinter(){};

        default public String beforePrefix(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
            return "";
        }

        default public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
            return "";
        }

        default public String afterSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
            return "";
        }
    }
}

