/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.remote.Remote;

public final class Checksum {
    private static final byte[] HEX_ARRAY = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);
    private final String algorithm;
    private final byte[] value;

    public String getHexValue() {
        byte[] hexChars = new byte[this.value.length * 2];
        for (int j = 0; j < this.value.length; ++j) {
            int v = this.value[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static Checksum fromHex(String algorithm, String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex string must contain a set of hex pairs (length divisible by 2).");
        }
        byte[] value = new byte[hex.length() / 2];
        for (int i = 0; i < value.length; ++i) {
            int index = i * 2;
            int n = Integer.parseInt(hex.substring(index, index + 2), 16);
            value[i] = (byte)n;
        }
        return new Checksum(algorithm, value);
    }

    public static Checksum fromUri(HttpSender httpSender, URI uri) {
        String uriStr = uri.toString();
        if (uriStr.endsWith(".sha256")) {
            return Checksum.fromUri(httpSender, uri, "SHA-256");
        }
        if (uriStr.endsWith(".md5")) {
            return Checksum.fromUri(httpSender, uri, "MD5");
        }
        throw new IllegalArgumentException("Unable to automatically determine checksum type from URI: " + uriStr);
    }

    public static Checksum fromUri(HttpSender httpSender, URI uri, String algorithm) {
        HttpSender.Request request = HttpSender.Request.build(uri.toString(), httpSender).withMethod(HttpSender.Method.GET).build();
        try (HttpSender.Response response = httpSender.send(request);){
            String hexString = new String(response.getBodyAsBytes(), StandardCharsets.UTF_8);
            Checksum checksum = Checksum.fromHex(algorithm, hexString);
            return checksum;
        }
    }

    public static SourceFile md5(SourceFile sourceFile, ExecutionContext ctx) {
        return Checksum.checksum(sourceFile, "MD5", ctx);
    }

    public static SourceFile sha256(SourceFile sourceFile, ExecutionContext ctx) {
        return Checksum.checksum(sourceFile, "SHA-256", ctx);
    }

    public static SourceFile checksum(SourceFile sourceFile, @org.jspecify.annotations.Nullable String algorithm, ExecutionContext ctx) {
        Object t;
        if (algorithm == null) {
            return sourceFile;
        }
        MessageDigest md = MessageDigest.getInstance(algorithm);
        InputStream is = sourceFile instanceof Remote ? ((Remote)sourceFile).getInputStream(ctx) : Files.newInputStream(sourceFile.getSourcePath(), new OpenOption[0]);
        DigestInputStream dis = new DigestInputStream(is, md);
        try {
            while (dis.read() != -1) {
            }
            t = sourceFile.withChecksum(new Checksum(algorithm, md.digest()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }
        dis.close();
        return t;
    }

    @Generated
    public Checksum(String algorithm, byte[] value) {
        this.algorithm = algorithm;
        this.value = value;
    }

    @Generated
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public byte[] getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Checksum)) {
            return false;
        }
        Checksum other = (Checksum)o;
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "Checksum(algorithm=" + this.getAlgorithm() + ", value=" + Arrays.toString(this.getValue()) + ")";
    }
}

